/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1609")
public class SAMAnnotatedCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final MethodMatchers OBJECT_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().names(new String[]{"equals"}).addParametersMatcher(new String[]{"java.lang.Object"}).build(), MethodMatchers.create().ofAnyType().names(new String[]{"getClass"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"hashcode"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"notify"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"notifyAll"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"toString"}).addWithoutParametersMatcher().build(), MethodMatchers.create().ofAnyType().names(new String[]{"wait"}).addWithoutParametersMatcher().addParametersMatcher(new String[]{"long"}).addParametersMatcher(new String[]{"long", "int"}).build()});

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        if (SAMAnnotatedCheck.hasOneAbstractMethod(classTree.symbol()) && !SAMAnnotatedCheck.isAnnotated(classTree)) {
            IdentifierTree simpleName = classTree.simpleName();
            this.reportIssue((Tree)simpleName, "Annotate the \"" + simpleName.name() + "\" interface with the @FunctionalInterface annotation" + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean isAnnotated(ClassTree tree) {
        return tree.symbol().metadata().isAnnotatedWith("java.lang.FunctionalInterface");
    }

    private static boolean hasOneAbstractMethod(Symbol.TypeSymbol symbol) {
        return SAMAnnotatedCheck.numberOfAbstractMethod((Symbol)symbol) == 1L && SAMAnnotatedCheck.noAbstractMethodInParentInterfaces(symbol.interfaces());
    }

    private static boolean noAbstractMethodInParentInterfaces(List<Type> interfaces) {
        return interfaces.stream().map(Type::symbol).noneMatch(symbol -> SAMAnnotatedCheck.numberOfAbstractMethod((Symbol)symbol) > 0L || !SAMAnnotatedCheck.noAbstractMethodInParentInterfaces(symbol.interfaces()));
    }

    private static long numberOfAbstractMethod(Symbol symbol) {
        if (symbol.isUnknown()) {
            return Integer.MAX_VALUE;
        }
        Symbol.TypeSymbol interfaceSymbol = (Symbol.TypeSymbol)symbol;
        return interfaceSymbol.memberSymbols().stream().filter(Symbol::isMethodSymbol).filter(member -> {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)member;
            return SAMAnnotatedCheck.isNotObjectMethod(methodSymbol) && methodSymbol.isAbstract();
        }).count();
    }

    private static boolean isNotObjectMethod(Symbol.MethodSymbol method) {
        MethodTree declaration = method.declaration();
        return declaration == null || !OBJECT_METHODS.matches(declaration);
    }
}

