/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1612")
public class ReplaceLambdaByMethodRefCheck
extends SubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        this.visitLambdaExpression((LambdaExpressionTree)tree);
    }

    private void visitLambdaExpression(LambdaExpressionTree tree) {
        if (ReplaceLambdaByMethodRefCheck.isReplaceableSingleMethodInvocation(tree) || ReplaceLambdaByMethodRefCheck.isBodyBlockInvokingMethod(tree)) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.arrowToken(), "Replace this lambda with a method reference." + this.context.getJavaVersion().java8CompatibilityMessage());
        } else {
            ReplaceLambdaByMethodRefCheck.getNullCheck(tree).ifPresent(nullMethod -> this.context.reportIssue((JavaCheck)this, (Tree)tree.arrowToken(), "Replace this lambda with method reference 'Objects::" + nullMethod + "'." + this.context.getJavaVersion().java8CompatibilityMessage()));
        }
    }

    private static Optional<String> getNullCheck(LambdaExpressionTree lambda) {
        Tree lambdaBody = lambda.body();
        if (ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody)) {
            return ReplaceLambdaByMethodRefCheck.getNullCheckFromReturn((Tree)((BlockTree)lambdaBody).body().get(0), lambda);
        }
        return ReplaceLambdaByMethodRefCheck.getNullCheck(lambdaBody, lambda);
    }

    private static Optional<String> getNullCheckFromReturn(Tree statement, LambdaExpressionTree lambda) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            return ReplaceLambdaByMethodRefCheck.getNullCheck((Tree)((ReturnStatementTree)statement).expression(), lambda);
        }
        return Optional.empty();
    }

    private static Optional<String> getNullCheck(@Nullable Tree statement, LambdaExpressionTree tree) {
        ExpressionTree rightOperand;
        BinaryExpressionTree bet;
        ExpressionTree leftOperand;
        if (statement == null) {
            return Optional.empty();
        }
        Tree expr = statement;
        if (expr.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            expr = ExpressionUtils.skipParentheses((ExpressionTree)((ParenthesizedTree)statement));
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO}) && (ReplaceLambdaByMethodRefCheck.nullAgainstParam(leftOperand = ExpressionUtils.skipParentheses((ExpressionTree)(bet = (BinaryExpressionTree)expr).leftOperand()), rightOperand = ExpressionUtils.skipParentheses((ExpressionTree)bet.rightOperand()), tree) || ReplaceLambdaByMethodRefCheck.nullAgainstParam(rightOperand, leftOperand, tree))) {
            return Optional.of(expr.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) ? "isNull" : "nonNull");
        }
        return Optional.empty();
    }

    private static boolean nullAgainstParam(ExpressionTree o1, ExpressionTree o2, LambdaExpressionTree tree) {
        if (o1.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && o2.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            List parameters = tree.parameters();
            return parameters.size() == 1 && ((VariableTree)parameters.get(0)).symbol().equals(((IdentifierTree)o2).symbol());
        }
        return false;
    }

    private static boolean isReplaceableSingleMethodInvocation(LambdaExpressionTree lambdaTree) {
        return ReplaceLambdaByMethodRefCheck.isMethodInvocation(lambdaTree.body(), lambdaTree);
    }

    private static boolean isBodyBlockInvokingMethod(LambdaExpressionTree lambdaTree) {
        Tree lambdaBody = lambdaTree.body();
        if (ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(lambdaBody)) {
            Tree statement = (Tree)((BlockTree)lambdaBody).body().get(0);
            return ReplaceLambdaByMethodRefCheck.isExpressionStatementInvokingMethod(statement, lambdaTree) || ReplaceLambdaByMethodRefCheck.isReturnStatementInvokingMethod(statement, lambdaTree);
        }
        return false;
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && ((BlockTree)tree).body().size() == 1;
    }

    private static boolean isExpressionStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        return statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ReplaceLambdaByMethodRefCheck.isMethodInvocation((Tree)((ExpressionStatementTree)statement).expression(), lambdaTree);
    }

    private static boolean isReturnStatementInvokingMethod(Tree statement, LambdaExpressionTree lambdaTree) {
        return statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && ReplaceLambdaByMethodRefCheck.isMethodInvocation((Tree)((ReturnStatementTree)statement).expression(), lambdaTree);
    }

    private static boolean isMethodInvocation(@Nullable Tree tree, LambdaExpressionTree lambdaTree) {
        if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
            Arguments arguments;
            if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                if (((NewClassTree)tree).classBody() != null) {
                    return false;
                }
                arguments = ((NewClassTree)tree).arguments();
            } else {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (ReplaceLambdaByMethodRefCheck.hasMethodInvocationInMethodSelect(mit) || ReplaceLambdaByMethodRefCheck.hasNonFinalFieldInMethodSelect(mit)) {
                    return false;
                }
                arguments = mit.arguments();
            }
            List parameters = lambdaTree.parameters();
            return ReplaceLambdaByMethodRefCheck.matchingParameters(parameters, arguments) || arguments.isEmpty() && ReplaceLambdaByMethodRefCheck.isNoArgMethodInvocationFromLambdaParam(tree, parameters);
        }
        return false;
    }

    private static boolean hasMethodInvocationInMethodSelect(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = ReplaceLambdaByMethodRefCheck.getMemberSelect(mit);
        while (mse != null) {
            ExpressionTree expression = mse.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS})) {
                return true;
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                mse = (MemberSelectExpressionTree)expression;
                continue;
            }
            mse = null;
        }
        return false;
    }

    @CheckForNull
    private static MemberSelectExpressionTree getMemberSelect(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (!methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return null;
        }
        return (MemberSelectExpressionTree)methodSelect;
    }

    private static boolean hasNonFinalFieldInMethodSelect(MethodInvocationTree mit) {
        MemberSelectExpressionTree mse = ReplaceLambdaByMethodRefCheck.getMemberSelect(mit);
        if (mse == null) {
            return false;
        }
        ExpressionTree expression = ExpressionUtils.skipParentheses((ExpressionTree)mse.expression());
        Symbol symbol = null;
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            symbol = ((IdentifierTree)expression).symbol();
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            symbol = ((MemberSelectExpressionTree)expression).identifier().symbol();
        }
        return symbol != null && symbol.owner().isTypeSymbol() && !ReplaceLambdaByMethodRefCheck.isThisOrSuper(symbol.name()) && !symbol.isFinal();
    }

    private static boolean isThisOrSuper(String name) {
        return "this".equals(name) || "super".equals(name);
    }

    private static boolean matchingParameters(List<VariableTree> parameters, Arguments arguments) {
        return arguments.size() == parameters.size() && IntStream.range(0, arguments.size()).allMatch(i -> {
            List usages = ((VariableTree)parameters.get(i)).symbol().usages();
            return usages.size() == 1 && ((IdentifierTree)usages.get(0)).equals(arguments.get(i));
        });
    }

    private static boolean isNoArgMethodInvocationFromLambdaParam(Tree tree, List<VariableTree> parameters) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) || parameters.size() != 1) {
            return false;
        }
        ExpressionTree methodSelect = ((MethodInvocationTree)tree).methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            Symbol parameterSymbol = parameters.get(0).symbol();
            return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && !parameterSymbol.isUnknown() && !ReplaceLambdaByMethodRefCheck.isAmbiguous((MethodInvocationTree)tree, parameterSymbol) && parameterSymbol.equals(((IdentifierTree)expression).symbol());
        }
        return false;
    }

    private static boolean isAmbiguous(MethodInvocationTree tree, Symbol parameterSymbol) {
        Symbol method = tree.symbol();
        Symbol.TypeSymbol methodOwner = (Symbol.TypeSymbol)method.owner();
        if (methodOwner.isUnknown() || method.isUnknown()) {
            return true;
        }
        return methodOwner.lookupSymbols(method.name()).stream().filter(Symbol::isMethodSymbol).map(s -> (Symbol.MethodSymbol)s).filter(m -> !m.isStatic() && m.parameterTypes().isEmpty() || m.isStatic() && m.parameterTypes().size() == 1 && parameterSymbol.type().isSubtypeOf((Type)m.parameterTypes().get(0))).count() > 1L;
    }
}

