/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S5128")
public class MissingBeanValidationCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVAX_VALIDATION_VALID = "javax.validation.Valid";
    private static final String JAVAX_VALIDATION_CONSTRAINT = "javax.validation.Constraint";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                this.checkField((VariableTree)member);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            this.checkMethod((MethodTree)member);
        }
    }

    private void checkField(VariableTree field) {
        MissingBeanValidationCheck.getIssueMessage(field).ifPresent(message -> this.reportIssue((Tree)field.type(), (String)message));
    }

    private void checkMethod(MethodTree method) {
        if (!MissingBeanValidationCheck.isExcluded(method)) {
            for (VariableTree parameter : method.parameters()) {
                MissingBeanValidationCheck.getIssueMessage(parameter).ifPresent(message -> this.reportIssue((Tree)parameter.type(), (String)message));
            }
        }
    }

    private static boolean isExcluded(MethodTree methodTree) {
        return methodTree.symbol().isPrivate() || MissingBeanValidationCheck.isInConstraintValidator(methodTree);
    }

    private static boolean isInConstraintValidator(MethodTree methodTree) {
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        return enclosingClass != null && enclosingClass.type().isSubtypeOf("javax.validation.ConstraintValidator");
    }

    private static Optional<String> getIssueMessage(VariableTree variable) {
        if (!MissingBeanValidationCheck.validationEnabled(variable) && MissingBeanValidationCheck.validationSupported(variable)) {
            return Optional.of(MessageFormat.format("Add missing \"@Valid\" on \"{0}\" to validate it with \"Bean Validation\".", variable.simpleName()));
        }
        return Optional.empty();
    }

    private static boolean validationEnabled(VariableTree variable) {
        if (variable.symbol().metadata().isAnnotatedWith(JAVAX_VALIDATION_VALID)) {
            return true;
        }
        return MissingBeanValidationCheck.typeArgumentAnnotations(variable).anyMatch(annotation -> annotation.is(JAVAX_VALIDATION_VALID));
    }

    private static Stream<Type> typeArgumentAnnotations(VariableTree variable) {
        return MissingBeanValidationCheck.typeArgumentTypeTrees(variable).flatMap(type -> type.annotations().stream()).map(ExpressionTree::symbolType);
    }

    private static Stream<TypeTree> typeArgumentTypeTrees(VariableTree variable) {
        TypeTree variableType = variable.type();
        if (!variableType.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            return Stream.empty();
        }
        return ((ParameterizedTypeTree)variableType).typeArguments().stream().map(TypeTree.class::cast);
    }

    private static boolean validationSupported(VariableTree variable) {
        return MissingBeanValidationCheck.annotationInstances(variable).anyMatch(MissingBeanValidationCheck::isConstraintAnnotation);
    }

    private static Stream<SymbolMetadata.AnnotationInstance> annotationInstances(VariableTree variable) {
        if (variable.type().is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            return MissingBeanValidationCheck.typeArgumentAnnotationInstances(variable);
        }
        Symbol.TypeSymbol classSymbol = variable.symbol().type().symbol();
        return MissingBeanValidationCheck.classAndFieldAnnotationInstances(classSymbol);
    }

    private static Stream<SymbolMetadata.AnnotationInstance> typeArgumentAnnotationInstances(VariableTree variable) {
        return MissingBeanValidationCheck.typeArgumentTypeTrees(variable).map(TypeTree::symbolType).map(Type::symbol).flatMap(MissingBeanValidationCheck::classAndFieldAnnotationInstances);
    }

    private static Stream<SymbolMetadata.AnnotationInstance> classAndFieldAnnotationInstances(Symbol.TypeSymbol classSymbol) {
        return Stream.concat(MissingBeanValidationCheck.classAnnotationInstances((Symbol)classSymbol), MissingBeanValidationCheck.fieldAnnotationInstances(classSymbol));
    }

    private static Stream<SymbolMetadata.AnnotationInstance> classAnnotationInstances(Symbol classSymbol) {
        return classSymbol.metadata().annotations().stream();
    }

    private static Stream<SymbolMetadata.AnnotationInstance> fieldAnnotationInstances(Symbol.TypeSymbol classSymbol) {
        return classSymbol.memberSymbols().stream().flatMap(MissingBeanValidationCheck::classAnnotationInstances);
    }

    private static boolean isConstraintAnnotation(SymbolMetadata.AnnotationInstance annotationInstance) {
        return annotationInstance.symbol().metadata().isAnnotatedWith(JAVAX_VALIDATION_CONSTRAINT);
    }
}

