/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2973")
public class EscapedUnicodeCharactersCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> UNICODE_WHITESPACES = ImmutableSet.of((Object)"1680", (Object)"2000", (Object)"2001", (Object)"2002", (Object)"2003", (Object)"2004", (Object[])new String[]{"2005", "2006", "2007", "2008", "2009", "200A", "2028", "2029", "202F", "205F", "3000", "180E", "200B", "200C", "200D", "2060", "FEFF"});
    private static final Pattern UNICODE_ESCAPED_CHAR = Pattern.compile("\\\\u+[a-fA-F0-9]{4}");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.STRING_LITERAL);
    }

    public void visitNode(Tree node) {
        if (LiteralUtils.isEmptyString((Tree)node)) {
            return;
        }
        String value = LiteralUtils.trimQuotes((String)((LiteralTree)node).value());
        Matcher matcher = UNICODE_ESCAPED_CHAR.matcher(value.replace("\\\\", ""));
        List<String> matches = EscapedUnicodeCharactersCheck.getAllMatches(matcher);
        if (!matches.isEmpty()) {
            boolean notOnlyUnicodeEscaped;
            boolean bl = notOnlyUnicodeEscaped = !matcher.replaceAll("").isEmpty();
            if (notOnlyUnicodeEscaped && matches.stream().anyMatch(EscapedUnicodeCharactersCheck::isPrintableEscapedUnicode)) {
                this.reportIssue(node, "Remove this Unicode escape sequence and use the character instead.");
            }
        }
    }

    private static List<String> getAllMatches(Matcher matcher) {
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    private static boolean isPrintableEscapedUnicode(String input) {
        String hexValue = input.substring(input.length() - 4);
        if (UNICODE_WHITESPACES.contains(hexValue)) {
            return false;
        }
        int unicodePointDecimal = Integer.parseInt(hexValue, 16);
        return 31 < unicodePointDecimal && unicodePointDecimal < 127 || 160 < unicodePointDecimal;
    }
}

