/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2718")
public class DateUtilsTruncateCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final Set<String> FIRST_PARAMETER_TYPES = new HashSet<String>(Arrays.asList("java.util.Date", "java.util.Calendar", "java.lang.Object"));

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"org.apache.commons.lang.time.DateUtils"}).names(new String[]{"truncate"}).addParametersMatcher(params -> params.size() == 2 && FIRST_PARAMETER_TYPES.contains(((Type)params.get(0)).fullyQualifiedName()) && ((Type)params.get(1)).is("int")).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Use \"ZonedDateTime.truncatedTo\" instead." + this.context.getJavaVersion().java8CompatibilityMessage());
    }
}

