/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2177")
public class ConfusingOverloadCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> SERIALIZATION_METHOD_NAME = Sets.newHashSet((Object[])new String[]{"writeObject", "readObject", "readObjectNoData", "writeReplace", "readResolve"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        Symbol.MethodSymbol methodSymbol;
        Symbol.TypeSymbol owner;
        Type superClass;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        if (Boolean.FALSE.equals(methodTree.isOverriding()) && (superClass = (owner = (Symbol.TypeSymbol)(methodSymbol = methodTree.symbol()).owner()).superClass()) != null && !SERIALIZATION_METHOD_NAME.contains(methodSymbol.name())) {
            boolean reportStaticIssue = this.checkMethod((Tree)methodTree.simpleName(), methodSymbol, superClass);
            superClass = superClass.symbol().superClass();
            while (superClass != null && !reportStaticIssue) {
                reportStaticIssue = this.checkStaticMethod((Tree)methodTree.simpleName(), methodSymbol, superClass);
                superClass = superClass.symbol().superClass();
            }
        }
    }

    private boolean checkStaticMethod(Tree reportTree, Symbol.MethodSymbol methodSymbol, Type superClass) {
        for (Symbol methodWithSameName : superClass.symbol().lookupSymbols(methodSymbol.name())) {
            if (!methodWithSameName.isMethodSymbol() || !ConfusingOverloadCheck.hideStaticMethod(methodSymbol, (Symbol.MethodSymbol)methodWithSameName)) continue;
            this.reportIssue(reportTree, "Rename this method or make it \"static\".");
            return true;
        }
        return false;
    }

    private boolean checkMethod(Tree reportTree, Symbol.MethodSymbol methodSymbol, Type superClass) {
        boolean reportStaticIssue = false;
        for (Symbol methodWithSameName : superClass.symbol().lookupSymbols(methodSymbol.name())) {
            if (!methodWithSameName.isMethodSymbol()) continue;
            if (ConfusingOverloadCheck.hideStaticMethod(methodSymbol, (Symbol.MethodSymbol)methodWithSameName)) {
                this.reportIssue(reportTree, "Rename this method or make it \"static\".");
                reportStaticIssue = true;
                continue;
            }
            if (!ConfusingOverloadCheck.confusingOverload(methodSymbol, (Symbol.MethodSymbol)methodWithSameName)) continue;
            this.reportIssue(reportTree, ConfusingOverloadCheck.getMessage(methodWithSameName));
        }
        return reportStaticIssue;
    }

    private static String getMessage(Symbol methodWithSameName) {
        String message = "Rename this method or correct the type of the argument(s) to override the parent class method.";
        if (methodWithSameName.isPrivate()) {
            message = "Rename this method; there is a \"private\" method in the parent class with the same name.";
        }
        return message;
    }

    private static boolean hideStaticMethod(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol symbolWithSameName) {
        return symbolWithSameName.isStatic() && !methodSymbol.isStatic() && ConfusingOverloadCheck.isPotentialOverride(methodSymbol, symbolWithSameName);
    }

    static boolean isPotentialOverride(Symbol.MethodSymbol method, Symbol.MethodSymbol overrideeCandidate) {
        List methodParameterTypes = method.parameterTypes();
        List overrideeParameterTypes = overrideeCandidate.parameterTypes();
        if (methodParameterTypes.size() != overrideeParameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < methodParameterTypes.size(); ++i) {
            Type methodParam = (Type)methodParameterTypes.get(i);
            Type overrideeParamType = (Type)overrideeParameterTypes.get(i);
            if (methodParam.isUnknown() || overrideeParamType.isUnknown()) {
                return false;
            }
            if (methodParam.erasure().equals(overrideeParamType.erasure())) continue;
            return false;
        }
        return true;
    }

    private static boolean confusingOverload(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodWithSameName) {
        if (methodSymbol.isStatic()) {
            return false;
        }
        List argTypes = methodSymbol.parameterTypes();
        List parameterTypes = methodWithSameName.parameterTypes();
        if (argTypes.size() != parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < argTypes.size(); ++i) {
            Type argType = (Type)argTypes.get(i);
            if (!argType.isUnknown() && argType.name().equals(((Type)parameterTypes.get(i)).name())) continue;
            return false;
        }
        return true;
    }
}

