/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.check.Rule;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.checks.JavaFootprint;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.recognizers.CodeRecognizer;
import org.sonarsource.analyzer.recognizers.LanguageFootprint;

@DeprecatedRuleKey(ruleKey="CommentedOutCodeLine", repositoryKey="squid")
@Rule(key="S125")
public class CommentedOutCodeLineCheck
extends IssuableSubscriptionVisitor {
    private static final double THRESHOLD = 0.9;
    private static final String START_JSNI = "/*-{";
    private static final String END_JSNI = "}-*/";
    private static final String MESSAGE = "This block of commented-out lines of code should be removed.";
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new JavaFootprint());

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TOKEN);
    }

    public void visitToken(SyntaxToken syntaxToken) {
        ArrayList<AnalyzerMessage> issues = new ArrayList<AnalyzerMessage>();
        AnalyzerMessage previousRelatedIssue = null;
        int previousCommentLine = -1;
        for (SyntaxTrivia syntaxTrivia : syntaxToken.trivias()) {
            if (syntaxTrivia.startLine() != previousCommentLine + 1 && syntaxTrivia.startLine() != previousCommentLine) {
                previousRelatedIssue = null;
            }
            if (CommentedOutCodeLineCheck.isHeader(syntaxTrivia) || CommentedOutCodeLineCheck.isJavadoc(syntaxTrivia.comment()) || CommentedOutCodeLineCheck.isJSNI(syntaxTrivia.comment())) continue;
            previousRelatedIssue = this.collectIssues(issues, syntaxTrivia, previousRelatedIssue);
            previousCommentLine = syntaxTrivia.startLine();
        }
        DefaultJavaFileScannerContext scannerContext = (DefaultJavaFileScannerContext)this.context;
        issues.forEach(arg_0 -> ((DefaultJavaFileScannerContext)scannerContext).reportIssue(arg_0));
    }

    public AnalyzerMessage collectIssues(List<AnalyzerMessage> issues, SyntaxTrivia syntaxTrivia, @Nullable AnalyzerMessage previousRelatedIssue) {
        String[] lines = syntaxTrivia.comment().split("\r\n?|\n");
        AnalyzerMessage issue = previousRelatedIssue;
        for (int lineOffset = 0; lineOffset < lines.length; ++lineOffset) {
            int startColumn;
            String line = lines[lineOffset];
            if (CommentedOutCodeLineCheck.isJavadocLink(line) || !this.codeRecognizer.isLineOfCode(line)) continue;
            int startLine = syntaxTrivia.startLine() + lineOffset;
            int n = startColumn = lineOffset == 0 ? syntaxTrivia.column() : 0;
            if (issue != null) {
                issue.flows.add(Collections.singletonList(this.createAnalyzerMessage(startLine, startColumn, line, "Code")));
                continue;
            }
            issue = this.createAnalyzerMessage(startLine, startColumn, line, MESSAGE);
            issues.add(issue);
        }
        return issue;
    }

    private AnalyzerMessage createAnalyzerMessage(int startLine, int startColumn, String line, String message) {
        String lineWithoutCommentPrefix = line.replaceFirst("^(//|/\\*\\*?|[ \t]*\\*)?[ \t]*+", "");
        int prefixSize = line.length() - lineWithoutCommentPrefix.length();
        String lineWithoutCommentPrefixAndSuffix = lineWithoutCommentPrefix.replaceFirst("[ \t]+(\\*/)?$", "");
        AnalyzerMessage.TextSpan textSpan = new AnalyzerMessage.TextSpan(startLine, startColumn + prefixSize, startLine, startColumn + prefixSize + lineWithoutCommentPrefixAndSuffix.length());
        return new AnalyzerMessage((JavaCheck)this, (InputComponent)this.context.getInputFile(), textSpan, message, 0);
    }

    private static boolean isHeader(SyntaxTrivia syntaxTrivia) {
        return syntaxTrivia.startLine() == 1;
    }

    private static boolean isJavadocLink(String line) {
        return line.contains("{@link");
    }

    private static boolean isJavadoc(String comment) {
        return StringUtils.startsWith((String)comment, (String)"/**");
    }

    private static boolean isJSNI(String comment) {
        return StringUtils.startsWith((String)comment, (String)START_JSNI) && StringUtils.endsWith((String)comment, (String)END_JSNI);
    }
}

