/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S2440")
public class ClassWithOnlyStaticMethodsInstantiationCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree identifier = ((NewClassTree)tree).identifier();
        Symbol.TypeSymbol newClassTypeSymbol = identifier.symbolType().symbol();
        if (!newClassTypeSymbol.isEnum() && ClassWithOnlyStaticMethodsInstantiationCheck.hasOnlyStaticMethodsAndFields(newClassTypeSymbol) && !ClassWithOnlyStaticMethodsInstantiationCheck.instantiateOwnClass((Tree)identifier, newClassTypeSymbol)) {
            String message = "Remove this instantiation.";
            String name = ClassWithOnlyStaticMethodsInstantiationCheck.getNewClassName((Tree)identifier);
            if (name != null) {
                message = "Remove this instantiation of \"{0}\".";
            }
            this.reportIssue((Tree)identifier, MessageFormat.format(message, name));
        }
    }

    private static boolean instantiateOwnClass(Tree identifier, Symbol.TypeSymbol newClassTypeSymbol) {
        Type enclosingClassType = JUtils.enclosingClass((Tree)identifier).type();
        return enclosingClassType.equals(newClassTypeSymbol.type());
    }

    private static boolean hasOnlyStaticMethodsAndFields(Symbol.TypeSymbol newClassTypeSymbol) {
        Collection<Symbol> symbols = ClassWithOnlyStaticMethodsInstantiationCheck.filterMethodsAndFields(newClassTypeSymbol.memberSymbols());
        if (symbols.isEmpty()) {
            return false;
        }
        for (Symbol symbol : symbols) {
            if (symbol.isStatic()) continue;
            return false;
        }
        return ClassWithOnlyStaticMethodsInstantiationCheck.superTypesHaveOnlyStaticMethods(newClassTypeSymbol);
    }

    private static boolean superTypesHaveOnlyStaticMethods(Symbol.TypeSymbol newClassTypeSymbol) {
        Type superClass = newClassTypeSymbol.superClass();
        if (superClass != null && !superClass.is("java.lang.Object") && !ClassWithOnlyStaticMethodsInstantiationCheck.hasOnlyStaticMethodsAndFields(superClass.symbol())) {
            return false;
        }
        for (Type superInterface : newClassTypeSymbol.interfaces()) {
            if (ClassWithOnlyStaticMethodsInstantiationCheck.hasOnlyStaticMethodsAndFields(superInterface.symbol())) continue;
            return false;
        }
        return true;
    }

    private static Collection<Symbol> filterMethodsAndFields(Collection<Symbol> symbols) {
        ArrayList<Symbol> filtered = new ArrayList<Symbol>();
        for (Symbol symbol : symbols) {
            if ((!symbol.isVariableSymbol() || ClassWithOnlyStaticMethodsInstantiationCheck.isThisOrSuper(symbol)) && (!symbol.isMethodSymbol() || ClassWithOnlyStaticMethodsInstantiationCheck.isConstructor(symbol))) continue;
            filtered.add(symbol);
        }
        return filtered;
    }

    private static boolean isThisOrSuper(Symbol symbol) {
        String name = symbol.name();
        return "this".equals(name) || "super".equals(name);
    }

    private static boolean isConstructor(Symbol symbol) {
        return "<init>".equals(symbol.name());
    }

    @Nullable
    private static String getNewClassName(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)tree).identifier().name();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            return ClassWithOnlyStaticMethodsInstantiationCheck.getNewClassName((Tree)((ParameterizedTypeTree)tree).type());
        }
        return null;
    }
}

