/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2638")
public class ChangeMethodContractCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVAX_ANNOTATION_CHECK_FOR_NULL = "javax.annotation.CheckForNull";
    private static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    private static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        Symbol.MethodSymbol overridee = methodSymbol.overriddenSymbol();
        if (overridee != null && overridee.isMethodSymbol()) {
            this.checkContractChange(methodTree, overridee);
        }
    }

    private void checkContractChange(MethodTree methodTree, Symbol.MethodSymbol overridee) {
        if (MethodTreeUtils.isEqualsMethod(methodTree) && ((VariableTree)methodTree.parameters().get(0)).symbol().metadata().isAnnotatedWith(JAVAX_ANNOTATION_NONNULL)) {
            this.reportIssue((Tree)methodTree.parameters().get(0), "Equals method should accept null parameters and return false.");
            return;
        }
        for (int i = 0; i < methodTree.parameters().size(); ++i) {
            VariableTree parameter = (VariableTree)methodTree.parameters().get(i);
            this.checkParameter(parameter, JUtils.parameterAnnotations((Symbol.MethodSymbol)overridee, (int)i));
        }
        if (ChangeMethodContractCheck.nonNullVsNull((Symbol)overridee, methodTree.symbol().metadata())) {
            for (AnnotationTree annotationTree : methodTree.modifiers().annotations()) {
                if (!annotationTree.symbolType().is(JAVAX_ANNOTATION_NULLABLE) && !annotationTree.symbolType().is(JAVAX_ANNOTATION_CHECK_FOR_NULL)) continue;
                this.reportIssue((Tree)annotationTree, "Remove this \"" + annotationTree.symbolType().name() + "\" annotation to honor the overridden method's contract.");
            }
        }
    }

    private void checkParameter(VariableTree parameter, SymbolMetadata overrideeParamMetadata) {
        VariableTree reportTree = parameter;
        if (ChangeMethodContractCheck.nonNullVsNull(parameter.symbol(), overrideeParamMetadata)) {
            for (AnnotationTree annotationTree : parameter.modifiers().annotations()) {
                if (!annotationTree.symbolType().is(JAVAX_ANNOTATION_NONNULL)) continue;
                reportTree = annotationTree;
            }
            this.reportIssue((Tree)reportTree, "Remove this \"Nonnull\" annotation to honor the overridden method's contract.");
        }
    }

    private static boolean nonNullVsNull(Symbol sym1, SymbolMetadata metadata2) {
        return sym1.metadata().isAnnotatedWith(JAVAX_ANNOTATION_NONNULL) && (metadata2.isAnnotatedWith(JAVAX_ANNOTATION_NULLABLE) || metadata2.isAnnotatedWith(JAVAX_ANNOTATION_CHECK_FOR_NULL));
    }
}

