/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.checks.AtLeastOneConstructorCheck;
import org.sonar.java.checks.CollectionInappropriateCallsCheck;
import org.sonar.java.checks.ConstantsShouldBeStaticFinalCheck;
import org.sonar.java.checks.EqualsNotOverriddenInSubclassCheck;
import org.sonar.java.checks.EqualsNotOverridenWithCompareToCheck;
import org.sonar.java.checks.PrivateFieldUsedLocallyCheck;
import org.sonar.java.checks.SillyEqualsCheck;
import org.sonar.java.checks.UselessImportCheck;
import org.sonar.java.checks.UtilityClassWithPublicConstructorCheck;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.naming.BadFieldNameCheck;
import org.sonar.java.checks.unused.UnusedPrivateFieldCheck;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

public class LombokFilter
extends BaseTreeVisitorIssueFilter {
    private static final Set<Class<? extends JavaCheck>> FILTERED_RULES = ImmutableSet.of(UnusedPrivateFieldCheck.class, PrivateFieldUsedLocallyCheck.class, EqualsNotOverriddenInSubclassCheck.class, EqualsNotOverridenWithCompareToCheck.class, UtilityClassWithPublicConstructorCheck.class, AtLeastOneConstructorCheck.class, (Object[])new Class[]{BadFieldNameCheck.class, ConstantsShouldBeStaticFinalCheck.class, SillyEqualsCheck.class, CollectionInappropriateCallsCheck.class, UselessImportCheck.class});
    private static final String LOMBOK_VAL = "lombok.val";
    private static final List<String> GENERATE_UNUSED_FIELD_RELATED_METHODS = ImmutableList.builder().add((Object)"lombok.Getter").add((Object)"lombok.Setter").add((Object)"lombok.Builder").add((Object)"lombok.ToString").add((Object)"lombok.AllArgsConstructor").add((Object)"lombok.NoArgsConstructor").add((Object)"lombok.RequiredArgsConstructor").build();
    private static final List<String> GENERATE_CONSTRUCTOR = ImmutableList.builder().add((Object)"lombok.AllArgsConstructor").add((Object)"lombok.NoArgsConstructor").add((Object)"lombok.RequiredArgsConstructor").build();
    private static final List<String> GENERATE_EQUALS = ImmutableList.builder().add((Object)"lombok.EqualsAndHashCode").add((Object)"lombok.Data").add((Object)"lombok.Value").build();
    private static final List<String> UTILITY_CLASS = ImmutableList.builder().add((Object)"lombok.experimental.UtilityClass").build();

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return FILTERED_RULES;
    }

    public void visitImport(ImportTree tree) {
        String fullyQualifiedName = ExpressionsHelper.concatenate((ExpressionTree)tree.qualifiedIdentifier());
        this.excludeLinesIfTrue(fullyQualifiedName.startsWith("lombok."), (Tree)tree, (Class<? extends JavaCheck>)UselessImportCheck.class);
        super.visitImport(tree);
    }

    public void visitClass(ClassTree tree) {
        boolean generatesEquals = LombokFilter.usesAnnotation(tree, GENERATE_EQUALS);
        this.excludeLinesIfTrue(generatesEquals || LombokFilter.usesAnnotation(tree, GENERATE_UNUSED_FIELD_RELATED_METHODS), (Tree)tree, UnusedPrivateFieldCheck.class, PrivateFieldUsedLocallyCheck.class);
        this.excludeLinesIfTrue(LombokFilter.usesAnnotation(tree, GENERATE_CONSTRUCTOR), (Tree)tree, (Class<? extends JavaCheck>)AtLeastOneConstructorCheck.class);
        this.excludeLinesIfTrue(generatesEquals, (Tree)tree, EqualsNotOverriddenInSubclassCheck.class, EqualsNotOverridenWithCompareToCheck.class);
        this.excludeLinesIfTrue(LombokFilter.generatesPrivateConstructor(tree), (Tree)tree, (Class<? extends JavaCheck>)UtilityClassWithPublicConstructorCheck.class);
        this.excludeLinesIfTrue(LombokFilter.usesAnnotation(tree, UTILITY_CLASS), (Tree)tree, BadFieldNameCheck.class, ConstantsShouldBeStaticFinalCheck.class);
        super.visitClass(tree);
    }

    @SafeVarargs
    private final void excludeLinesIfTrue(boolean shouldExclude, Tree tree, Class<? extends JavaCheck> ... rules) {
        for (Class<? extends JavaCheck> rule : rules) {
            this.excludeLinesIfTrue(shouldExclude, tree, rule);
        }
    }

    private void excludeLinesIfTrue(boolean shouldExclude, Tree tree, Class<? extends JavaCheck> rule) {
        if (shouldExclude) {
            this.excludeLines(tree, rule);
        } else {
            this.acceptLines(tree, rule);
        }
    }

    private static boolean usesAnnotation(ClassTree classTree, List<String> annotations) {
        SymbolMetadata classMetadata = classTree.symbol().metadata();
        return annotations.stream().anyMatch(arg_0 -> ((SymbolMetadata)classMetadata).isAnnotatedWith(arg_0));
    }

    private static boolean generatesPrivateConstructor(ClassTree classTree) {
        if (LombokFilter.usesAnnotation(classTree, UTILITY_CLASS)) {
            return true;
        }
        SymbolMetadata metadata = classTree.symbol().metadata();
        return GENERATE_CONSTRUCTOR.stream().map(arg_0 -> ((SymbolMetadata)metadata).valuesForAnnotation(arg_0)).filter(Objects::nonNull).anyMatch(LombokFilter::generatesPrivateAccess);
    }

    private static boolean generatesPrivateAccess(List<SymbolMetadata.AnnotationValue> values) {
        return values.stream().anyMatch(av -> "access".equals(av.name()) && "PRIVATE".equals(LombokFilter.getAccessLevelValue(av.value())));
    }

    @Nullable
    private static String getAccessLevelValue(Object value) {
        if (value instanceof Tree) {
            Tree tree = (Tree)value;
            if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                return ((MemberSelectExpressionTree)tree).identifier().name();
            }
            if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return ((IdentifierTree)tree).name();
            }
        }
        return null;
    }

    public void visitIdentifier(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        if (symbol.isVariableSymbol() && symbol.type().is(LOMBOK_VAL)) {
            LombokFilter.parentMethodInvocation(tree).ifPresent(mit -> this.excludeLines((Tree)mit, (Iterable<Class<? extends JavaCheck>>)Arrays.asList(SillyEqualsCheck.class, CollectionInappropriateCallsCheck.class)));
        }
        super.visitIdentifier(tree);
    }

    private static Optional<Tree> parentMethodInvocation(IdentifierTree identifier) {
        Tree parent;
        for (parent = identifier.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}); parent = parent.parent()) {
        }
        return Optional.ofNullable(parent);
    }
}

