/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4502")
public class SpringSecurityDisableCSRFCheck
extends AbstractMethodDetection {
    private static final String CSRF_CONFIGURER_CLASS = "org.springframework.security.config.annotation.web.configurers.CsrfConfigurer";
    private static final String MESSAGE = "Make sure disabling Spring Security's CSRF protection is safe here.";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer")).name("disable").withoutParameter());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        MemberSelectExpressionTree selectExpression;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (selectExpression = (MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType().is(CSRF_CONFIGURER_CLASS)) {
            this.reportIssue((Tree)selectExpression.identifier(), MESSAGE);
        }
    }
}

