/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5344")
public class PasswordEncoderCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher JDBC_AUTHENTICATION = MethodMatcher.create().typeDefinition("org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder").name("jdbcAuthentication").withoutParameter();
    private static final MethodMatcher USER_DETAIL_SERVICE = MethodMatcher.create().typeDefinition("org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder").name("userDetailsService").withAnyParameters();
    private static final MethodMatcher PASSWORD_ENCODER_SETTER = MethodMatcher.create().typeDefinition("org.springframework.security.config.annotation.authentication.configurers.userdetails.AbstractDaoAuthenticationConfigurer").name("passwordEncoder").withAnyParameters();
    private static final MethodMatcherCollection UNSAFE_PASSWORD_ENCODERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{PasswordEncoderCheck.constructorMatcher("org.springframework.security.authentication.encoding.ShaPasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.authentication.encoding.Md5PasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.crypto.password.LdapShaPasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.crypto.password.Md4PasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.crypto.password.MessageDigestPasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.crypto.password.NoOpPasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.crypto.password.StandardPasswordEncoder").withAnyParameters(), PasswordEncoderCheck.constructorMatcher("org.springframework.security.crypto.password.SCryptPasswordEncoder").withAnyParameters()});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && UNSAFE_PASSWORD_ENCODERS.anyMatch((NewClassTree)tree)) {
            this.reportIssue((Tree)((NewClassTree)tree).identifier(), "Use secure \"PasswordEncoder\" implementation.");
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodInvocationVisitor visitor = new MethodInvocationVisitor();
            tree.accept((TreeVisitor)visitor);
            if (visitor.hasAuthentication && !visitor.setsPasswordEncoder) {
                this.reportIssue((Tree)visitor.tree, "Don't use the default \"PasswordEncoder\" relying on plain-text.");
            }
        }
    }

    private static MethodMatcher constructorMatcher(String fullyQualifiedName) {
        return MethodMatcher.create().typeDefinition(fullyQualifiedName).name("<init>");
    }

    static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private boolean hasAuthentication;
        private boolean setsPasswordEncoder;
        private MethodInvocationTree tree;

        MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (JDBC_AUTHENTICATION.matches(tree) || USER_DETAIL_SERVICE.matches(tree)) {
                this.hasAuthentication = true;
                this.tree = tree;
            }
            if (PASSWORD_ENCODER_SETTER.matches(tree)) {
                this.setsPasswordEncoder = true;
            }
            super.visitMethodInvocation(tree);
        }
    }
}

