/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S4792")
public class LogConfigurationCheck
extends AbstractMethodDetection {
    private static final String LOG4J_CONFIGURATOR = "org.apache.logging.log4j.core.config.Configurator";
    private static final String LOG4J_CONFIGURATION_SOURCE = "org.apache.logging.log4j.core.config.ConfigurationSource";
    private static final String MESSAGE = "Make sure that this logger's configuration is safe.";
    private static final String SET_LEVEL = "setLevel";
    private static final String ADD_APPENDER = "addAppender";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_REFERENCE, Tree.Kind.CLASS);
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory").name("newConfigurationBuilder").withoutParameter(), MethodMatcher.create().typeDefinition(LOG4J_CONFIGURATOR).name("setAllLevels").withAnyParameters(), MethodMatcher.create().typeDefinition(LOG4J_CONFIGURATOR).name(SET_LEVEL).withAnyParameters(), MethodMatcher.create().typeDefinition(LOG4J_CONFIGURATOR).name("setRootLevel").withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.logging.log4j.core.config.Configuration").name(ADD_APPENDER).withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.logging.log4j.core.config.LoggerConfig").name(ADD_APPENDER).withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.logging.log4j.core.config.LoggerConfig").name(SET_LEVEL).withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.logging.log4j.core.LoggerContext").name("setConfigLocation").withAnyParameters(), MethodMatcher.create().typeDefinition(LOG4J_CONFIGURATION_SOURCE).name("<init>").withAnyParameters(), MethodMatcher.create().typeDefinition(LOG4J_CONFIGURATION_SOURCE).name("fromResource").withAnyParameters(), MethodMatcher.create().typeDefinition(LOG4J_CONFIGURATION_SOURCE).name("fromUri").withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.logging.LogManager").name("readConfiguration").withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.logging.Logger").name(SET_LEVEL).withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.logging.Logger").name("addHandler").withAnyParameters(), MethodMatcher.create().typeDefinition("ch.qos.logback.classic.Logger").name(ADD_APPENDER).withAnyParameters(), MethodMatcher.create().typeDefinition("ch.qos.logback.classic.Logger").name(SET_LEVEL).withAnyParameters(), MethodMatcher.create().typeDefinition("ch.qos.logback.classic.joran.JoranConfigurator").name("<init>").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.System").name("setProperty").parameters(new String[]{"java.lang.String", "java.lang.String"}));
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            this.checkConfigurationFactoryExtension((ClassTree)tree);
        } else {
            super.visitNode(tree);
        }
    }

    private void checkConfigurationFactoryExtension(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        if (superClass != null && superClass.symbolType().is("org.apache.logging.log4j.core.config.ConfigurationFactory")) {
            this.reportIssue((Tree)superClass, MESSAGE);
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().name().equals("setProperty")) {
            String stringConstant = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value();
            if ("logback.configurationFile".equals(stringConstant)) {
                this.reportIssue((Tree)mit, MESSAGE);
            }
        } else {
            this.reportIssue((Tree)mit, MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree, MESSAGE);
    }
}

