/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5324")
public class AndroidExternalStorageCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("android.os.Environment").name("getExternalStorageDirectory").withAnyParameters(), MethodMatcher.create().typeDefinition("android.os.Environment").name("getExternalStoragePublicDirectory").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getExternalFilesDir").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getExternalFilesDirs").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getExternalMediaDirs").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getExternalCacheDir").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getExternalCacheDirs").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getObbDir").withAnyParameters(), MethodMatcher.create().typeDefinition("android.content.Context").name("getObbDirs").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit, "Make sure that external files are accessed safely here.");
    }
}

