/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;

@Rule(key="S00119")
@RspecKey(value="S119")
public class BadTypeParameterNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z][0-9]?$";
    @RuleProperty(key="format", description="Regular expression used to check the type parameter names against.", defaultValue="^[A-Z][0-9]?$")
    public String format = "^[A-Z][0-9]?$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TYPE_PARAMETER);
    }

    public void setContext(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        IdentifierTree identifier = ((TypeParameterTree)tree).identifier();
        if (!this.pattern.matcher(identifier.name()).matches()) {
            this.reportIssue((Tree)identifier, "Rename this generic name to match the regular expression '" + this.format + "'.");
        }
    }
}

