/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3077")
public class VolatileNonPrimitiveFieldCheck
extends IssuableSubscriptionVisitor {
    private static final String REF_MESSAGE = "Remove the \"volatile\" keyword from this field.";
    private static final String ARRAY_MESSAGE = "Use an \"Atomic%sArray\" instead.";
    private static final List<String> STANDARD_IMMUTABLE_TYPES = Arrays.asList("java.awt.Color", "java.awt.Cursor", "java.awt.Font", "java.io.File", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.net.Inet4Address", "java.net.Inet6Address", "java.net.URL", "java.time.Clock", "java.time.DayOfWeek", "java.time.Instant", "java.time.LocalDate", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.Month", "java.time.MonthDay", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Year", "java.time.YearMonth", "java.time.ZoneId", "java.time.ZoneOffset", "java.time.ZonedDateTime", "java.time.Duration", "java.time.Period", "java.util.Locale", "java.util.UUID");

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ((ClassTree)tree).members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(m -> (VariableTree)m).filter(v -> ModifiersUtils.hasModifier((ModifiersTree)v.modifiers(), (Modifier)Modifier.VOLATILE)).filter(v -> !v.type().symbolType().isPrimitive()).filter(v -> !VolatileNonPrimitiveFieldCheck.isImmutableType(v.type().symbolType())).forEach(v -> this.reportIssue((Tree)ModifiersUtils.getModifier((ModifiersTree)v.modifiers(), (Modifier)Modifier.VOLATILE), (Tree)v.type(), VolatileNonPrimitiveFieldCheck.getMessage(v)));
    }

    private static boolean isImmutableType(Type type) {
        return STANDARD_IMMUTABLE_TYPES.stream().anyMatch(arg_0 -> ((Type)type).is(arg_0));
    }

    private static String getMessage(VariableTree variableTree) {
        Type varType = variableTree.type().symbolType();
        if (varType.isArray()) {
            String atomicType = "Reference";
            Type elementType = ((Type.ArrayType)varType).elementType();
            if (elementType.isPrimitive(Type.Primitives.LONG)) {
                atomicType = "Long";
            } else if (elementType.isPrimitive(Type.Primitives.INT)) {
                atomicType = "Integer";
            }
            return String.format(ARRAY_MESSAGE, atomicType);
        }
        return REF_MESSAGE;
    }
}

