/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S923")
public class VarArgCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        SyntaxToken ellipsisToken;
        TypeTree lastParam;
        List parameters = ((MethodTree)tree).parameters();
        if (!parameters.isEmpty() && (lastParam = ((VariableTree)parameters.get(parameters.size() - 1)).type()).is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE}) && (ellipsisToken = ((ArrayTypeTree)lastParam).ellipsisToken()) != null) {
            this.reportIssue((Tree)ellipsisToken, "Do not use varargs.");
        }
    }
}

