/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2236")
public class ThreadWaitCallCheck
extends AbstractMethodDetection {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Refactor the synchronisation mechanism to not use a Thread instance as a monitor");
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        TypeCriteria subtypeOfThread = TypeCriteria.subtypeOf((String)"java.lang.Thread");
        return Arrays.asList(MethodMatcher.create().callSite(subtypeOfThread).name("wait").withoutParameter(), MethodMatcher.create().callSite(subtypeOfThread).name("wait").addParameter("long"), MethodMatcher.create().callSite(subtypeOfThread).name("wait").addParameter("long").addParameter("int"), MethodMatcher.create().callSite(subtypeOfThread).name("notify").withoutParameter(), MethodMatcher.create().callSite(subtypeOfThread).name("notifyAll").withoutParameter());
    }
}

