/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2390")
public class SubClassStaticReferenceCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        Type classType = classTree.symbol().type();
        List members = classTree.members();
        this.checkStaticVariables(members, classType);
        this.checkStaticInitializers(members, classType);
    }

    private void checkStaticVariables(List<Tree> members, Type classType) {
        members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast).filter(SubClassStaticReferenceCheck::isStaticVariable).map(VariableTree::initializer).filter(Objects::nonNull).forEach(initializer -> initializer.accept((TreeVisitor)new StaticAccessVisitor(classType)));
    }

    private static boolean isStaticVariable(VariableTree tree) {
        return tree.symbol().isStatic();
    }

    private void checkStaticInitializers(List<Tree> members, Type classType) {
        members.stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})).forEach(tree -> tree.accept((TreeVisitor)new StaticAccessVisitor(classType)));
    }

    private class StaticAccessVisitor
    extends BaseTreeVisitor {
        private final Type classType;

        public StaticAccessVisitor(Type classType) {
            this.classType = classType;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.scan((Tree)tree.expression());
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (JavaKeyword.CLASS.getValue().equals(tree.identifier().name())) {
                return;
            }
            super.visitMemberSelectExpression(tree);
        }

        public void visitIdentifier(IdentifierTree tree) {
            Type type = tree.symbolType();
            if (type instanceof MethodJavaType) {
                type = ((MethodJavaType)type).resultType();
            }
            if (!this.sameErasure(type) && type.isSubtypeOf(this.classType.erasure())) {
                SubClassStaticReferenceCheck.this.reportIssue((Tree)tree, String.format("Remove this reference to \"%s\".", type.symbol().name()));
            }
        }

        private boolean sameErasure(Type type) {
            return this.classType.erasure().equals(type.erasure());
        }
    }
}

