/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S4682")
public final class PrimitivesMarkedNullableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        TypeTree returnType = methodTree.returnType();
        if (returnType.symbolType().isPrimitive()) {
            PrimitivesMarkedNullableCheck.findNullableAnnotation(methodTree).ifPresent(annotation -> this.reportIssue((Tree)returnType, String.format("\"%s\" annotation should not be used on primitive types", annotation)));
        }
    }

    private static Optional<String> findNullableAnnotation(MethodTree methodTree) {
        SymbolMetadata methodMetadata = methodTree.symbol().metadata();
        if (methodMetadata.isAnnotatedWith("javax.annotation.CheckForNull")) {
            return Optional.of("@CheckForNull");
        }
        if (methodMetadata.isAnnotatedWith("javax.annotation.Nullable")) {
            return Optional.of("@Nullable");
        }
        return Optional.empty();
    }
}

