/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4034")
public class PreferStreamAnyMatchCheck
extends AbstractMethodDetection {
    private static final Set<String> STREAM_TYPES = ImmutableSet.of((Object)"java.util.stream.Stream", (Object)"java.util.stream.IntStream", (Object)"java.util.stream.LongStream", (Object)"java.util.stream.DoubleStream");
    private static final MethodMatcherCollection FIND_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
    private static final MethodMatcherCollection MAP_METHODS;
    private static final MethodMatcherCollection FILTER_METHODS;
    private static final MethodMatcher BOOLEAN_VALUE;

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ArrayList<MethodMatcher> matchers = new ArrayList<MethodMatcher>();
        Stream.of("java.util.Optional", "java.util.OptionalInt", "java.util.OptionalLong", "java.util.OptionalDouble").map(type -> MethodMatcher.create().typeDefinition(type).name("isPresent").withoutParameter()).forEach(matchers::add);
        STREAM_TYPES.stream().map(type -> MethodMatcher.create().typeDefinition(type).name("anyMatch").addParameter("java.util.function.Predicate")).forEach(matchers::add);
        return matchers;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        if (methodName.equals("isPresent")) {
            this.handleIsPresent(mit);
        } else if (methodName.equals("anyMatch")) {
            this.handleAnyMatch(mit);
        }
    }

    private void handleAnyMatch(MethodInvocationTree anyMatchMIT) {
        ExpressionTree predicate = (ExpressionTree)anyMatchMIT.arguments().get(0);
        IdentifierTree reportTree = ExpressionUtils.methodName((MethodInvocationTree)anyMatchMIT);
        if (anyMatchMIT.parent().is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            if (predicate.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) && ((LambdaExpressionTree)predicate).body().is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
                this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "Replace this double negation with \"allMatch()\" and positive predicate.");
            } else {
                this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "Replace this negation and \"anyMatch()\" with \"noneMatch()\".");
            }
        }
        if (predicate.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}) && PreferStreamAnyMatchCheck.isBooleanValueReference((MethodReferenceTree)predicate)) {
            PreferStreamAnyMatchCheck.previousMITInChain(anyMatchMIT).filter(arg_0 -> ((MethodMatcherCollection)MAP_METHODS).anyMatch(arg_0)).ifPresent(mapMIT -> this.context.reportIssue((JavaCheck)this, (Tree)reportTree, "Use mapper from \"map()\" directly as predicate in \"anyMatch()\"."));
        }
    }

    private static boolean isBooleanValueReference(MethodReferenceTree predicate) {
        return BOOLEAN_VALUE.matches(predicate.method().symbol());
    }

    private void handleIsPresent(MethodInvocationTree isPresentMIT) {
        PreferStreamAnyMatchCheck.previousMITInChain(isPresentMIT).filter(arg_0 -> ((MethodMatcherCollection)FIND_METHODS).anyMatch(arg_0)).ifPresent(findMIT -> PreferStreamAnyMatchCheck.previousMITInChain(findMIT).filter(arg_0 -> ((MethodMatcherCollection)FILTER_METHODS).anyMatch(arg_0)).ifPresent(filterMIT -> this.context.reportIssue((JavaCheck)this, (Tree)ExpressionUtils.methodName((MethodInvocationTree)filterMIT), (Tree)ExpressionUtils.methodName((MethodInvocationTree)isPresentMIT), "Replace this \"filter()." + ExpressionUtils.methodName((MethodInvocationTree)findMIT).name() + "().isPresent()\" chain with \"anyMatch()\".")));
    }

    private static Optional<MethodInvocationTree> previousMITInChain(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree previousInvocation = (MethodInvocationTree)expression;
                return Optional.of(previousInvocation);
            }
        }
        return Optional.empty();
    }

    static {
        STREAM_TYPES.forEach(type -> {
            FIND_METHODS.add(MethodMatcher.create().typeDefinition(type).name("findFirst").withoutParameter());
            FIND_METHODS.add(MethodMatcher.create().typeDefinition(type).name("findAny").withoutParameter());
        });
        MAP_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
        STREAM_TYPES.forEach(type -> MAP_METHODS.add(MethodMatcher.create().typeDefinition(type).name("map").addParameter("java.util.function.Function")));
        FILTER_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]);
        STREAM_TYPES.forEach(type -> FILTER_METHODS.add(MethodMatcher.create().typeDefinition(type).name("filter").withAnyParameters()));
        BOOLEAN_VALUE = MethodMatcher.create().typeDefinition("java.lang.Boolean").name("booleanValue").withoutParameter();
    }
}

