/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2187")
public class NoTestInTestClassCheck
extends IssuableSubscriptionVisitor {
    private final Set<String> testAnnotations = new HashSet<String>();
    private final Set<String> seenAnnotations = new HashSet<String>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.resetAnnotationCache();
            CompilationUnitTree cut = (CompilationUnitTree)tree;
            cut.types().stream().filter(typeTree -> typeTree.is(new Tree.Kind[]{Tree.Kind.CLASS})).forEach(typeTree -> this.checkClass((ClassTree)typeTree));
        }
    }

    private void resetAnnotationCache() {
        this.testAnnotations.clear();
        this.seenAnnotations.clear();
        this.testAnnotations.add("org.junit.Test");
        this.testAnnotations.add("org.testng.annotations.Test");
        this.testAnnotations.add("org.junit.jupiter.api.Test");
    }

    private void checkClass(ClassTree classTree) {
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            Symbol.TypeSymbol classSymbol = classTree.symbol();
            Stream<Symbol.MethodSymbol> members = NoTestInTestClassCheck.getAllMembers(classSymbol, NoTestInTestClassCheck.checkRunWith(classSymbol, "Enclosed.class"));
            IdentifierTree simpleName = classTree.simpleName();
            if (classSymbol.metadata().isAnnotatedWith("org.testng.annotations.Test")) {
                this.checkTestNGmembers(simpleName, members);
            } else {
                boolean isJunit3TestClass = classSymbol.type().isSubtypeOf("junit.framework.TestCase");
                if (isJunit3TestClass) {
                    this.checkJunit3TestClass(simpleName, members);
                } else {
                    if (NoTestInTestClassCheck.runWitZohhak(classSymbol)) {
                        this.testAnnotations.add("com.googlecode.zohhak.api.TestWith");
                    }
                    this.checkJunit4AndAboveTestClass(simpleName, classSymbol, members);
                }
            }
        }
    }

    private void checkTestNGmembers(IdentifierTree className, Stream<Symbol.MethodSymbol> members) {
        if (members.noneMatch(member -> member.isPublic() && !member.isStatic() && member.returnType() != null)) {
            this.reportClass(className);
        }
    }

    private void checkJunit3TestClass(IdentifierTree className, Stream<Symbol.MethodSymbol> members) {
        if (members.noneMatch(m -> m.name().startsWith("test"))) {
            this.reportClass(className);
        }
    }

    private void checkJunit4AndAboveTestClass(IdentifierTree className, Symbol.TypeSymbol symbol, Stream<Symbol.MethodSymbol> members) {
        if (symbol.name().endsWith("Test") && !NoTestInTestClassCheck.runWithCucumberOrSuiteOrTheoriesRunner(symbol) && members.noneMatch(this::isTestMethod)) {
            this.reportClass(className);
        }
    }

    private static boolean runWithCucumberOrSuiteOrTheoriesRunner(Symbol.TypeSymbol symbol) {
        return NoTestInTestClassCheck.checkRunWith(symbol, "Cucumber.class", "Suite.class", "Theories.class");
    }

    private static boolean runWitZohhak(Symbol.TypeSymbol symbol) {
        return NoTestInTestClassCheck.checkRunWith(symbol, "ZohhakRunner.class");
    }

    private static boolean checkRunWith(Symbol.TypeSymbol symbol, String ... runnerClasses) {
        Object value;
        List annotationValues = symbol.metadata().valuesForAnnotation("org.junit.runner.RunWith");
        if (annotationValues != null && annotationValues.size() == 1 && (value = ((SymbolMetadata.AnnotationValue)annotationValues.get(0)).value()) instanceof MemberSelectExpressionTree) {
            String runnerParam = ExpressionsHelper.concatenate((ExpressionTree)value);
            for (String runnerClass : runnerClasses) {
                if (!runnerParam.endsWith(runnerClass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTestMethod(Symbol method) {
        return method.metadata().annotations().stream().anyMatch(input -> {
            Type type = input.symbol().type();
            return type.isUnknown() || this.isTestAnnotation(type);
        });
    }

    private boolean isTestAnnotation(Type type) {
        return this.testAnnotations.contains(type.fullyQualifiedName()) || this.isJUnitTestableMetaAnnotated(type);
    }

    private boolean isJUnitTestableMetaAnnotated(Type type) {
        if (this.seenAnnotations.contains(type.fullyQualifiedName())) {
            return false;
        }
        this.seenAnnotations.add(type.fullyQualifiedName());
        SymbolMetadata metadata = type.symbol().metadata();
        if (metadata.isAnnotatedWith("org.junit.platform.commons.annotation.Testable")) {
            this.testAnnotations.add(type.fullyQualifiedName());
            return true;
        }
        for (SymbolMetadata.AnnotationInstance annotation : metadata.annotations()) {
            if (!this.isJUnitTestableMetaAnnotated(annotation.symbol().type())) continue;
            this.testAnnotations.add(type.fullyQualifiedName());
            return true;
        }
        return false;
    }

    private static Stream<Symbol.MethodSymbol> getAllMembers(Symbol.TypeSymbol symbol, boolean isEnclosed) {
        return NoTestInTestClassCheck.getAllMembers(symbol, isEnclosed, new HashSet<Symbol>());
    }

    private static Stream<Symbol.MethodSymbol> getAllMembers(Symbol.TypeSymbol symbol, boolean isEnclosed, Set<Symbol> visitedSymbols) {
        Type superClass;
        if (!visitedSymbols.add((Symbol)symbol) || symbol.type().is("java.lang.Object")) {
            return Stream.empty();
        }
        Stream<Symbol.MethodSymbol> members = Stream.empty();
        if (!isEnclosed) {
            members = symbol.memberSymbols().stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast);
        }
        if ((superClass = symbol.superClass()) != null) {
            members = Stream.concat(members, NoTestInTestClassCheck.getAllMembers(superClass.symbol(), isEnclosed, visitedSymbols));
        }
        Stream<Symbol.MethodSymbol> defaultMethodsFromInterfaces = symbol.interfaces().stream().flatMap(i -> NoTestInTestClassCheck.getAllMembers(i.symbol(), false, visitedSymbols)).filter(m -> ((JavaSymbol.MethodJavaSymbol)m).isDefault());
        members = Stream.concat(members, defaultMethodsFromInterfaces);
        for (Symbol s : symbol.memberSymbols()) {
            if (!NoTestInTestClassCheck.isNested(s) && !NoTestInTestClassCheck.isPublicStaticConcrete(s)) continue;
            members = Stream.concat(members, NoTestInTestClassCheck.getAllMembers((Symbol.TypeSymbol)s, false, visitedSymbols));
        }
        return members;
    }

    private static boolean isNested(Symbol s) {
        return s.isTypeSymbol() && s.metadata().isAnnotatedWith("org.junit.jupiter.api.Nested");
    }

    private static boolean isPublicStaticConcrete(Symbol s) {
        return NoTestInTestClassCheck.isPublicStaticClass(s) && !s.isAbstract();
    }

    private static boolean isPublicStaticClass(Symbol symbol) {
        return symbol.isTypeSymbol() && symbol.isPublic() && symbol.isStatic();
    }

    private void reportClass(IdentifierTree className) {
        this.reportIssue((Tree)className, "Add some tests to this class.");
    }
}

