/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2211")
public class LambdaTypeParameterCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
        List parameters = lambdaExpressionTree.parameters();
        if (parameters.size() <= 2 && !lambdaExpressionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return;
        }
        String missingTypeParameters = parameters.stream().filter(variable -> variable.type().is(new Tree.Kind[]{Tree.Kind.INFERED_TYPE})).map(VariableTree::simpleName).map(IdentifierTree::name).map(parameterName -> "'" + parameterName + "'").collect(Collectors.joining(", "));
        if (!missingTypeParameters.isEmpty()) {
            this.reportIssue((Tree)parameters.get(0), (Tree)Iterables.getLast((Iterable)parameters), String.format("Specify a type for: %s", missingTypeParameters));
        }
    }
}

