/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4929")
public class InputStreamOverrideReadCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher READ_BYTES_INT_INT = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("read").parameters(new String[]{"byte[]", "int", "int"});
    private static final MethodMatcher READ_INT = MethodMatcher.create().typeDefinition(TypeCriteria.anyType()).name("read").parameters(new String[]{"int"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        Type superType = classTree.symbol().superClass();
        IdentifierTree className = classTree.simpleName();
        if (className == null || classTree.symbol().isAbstract() || superType == null || !superType.is("java.io.InputStream") && !superType.is("java.io.FilterInputStream")) {
            return;
        }
        Optional<MethodTree> readByteIntInt = InputStreamOverrideReadCheck.findMethod(classTree, READ_BYTES_INT_INT);
        if (!readByteIntInt.isPresent()) {
            String message = InputStreamOverrideReadCheck.findMethod(classTree, READ_INT).filter(readIntTree -> readIntTree.block().body().isEmpty()).map(readIntTree -> "Provide an empty override of \"read(byte[],int,int)\" for this class as well.").orElse("Provide an override of \"read(byte[],int,int)\" for this class.");
            this.reportIssue((Tree)className, message);
        }
    }

    private static Optional<MethodTree> findMethod(ClassTree classTree, MethodMatcher methodMatcher) {
        return classTree.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(MethodTree.class::cast).filter(arg_0 -> ((MethodMatcher)methodMatcher).matches(arg_0)).findFirst();
    }
}

