/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.CompareWithEqualsVisitor;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;

@Rule(key="S1698")
public class CompareObjectWithEqualsCheck
extends CompareWithEqualsVisitor {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatcher EQUALS_MATCHER = MethodMatcher.create().name("equals").parameters(new String[]{"java.lang.Object"});

    @Override
    protected void checkEqualityExpression(BinaryExpressionTree tree) {
        Type rightOpType;
        ExpressionTree leftExpression = tree.leftOperand();
        ExpressionTree rightExpression = tree.rightOperand();
        Type leftOpType = leftExpression.symbolType();
        if (!CompareObjectWithEqualsCheck.isExcluded(leftOpType, rightOpType = rightExpression.symbolType()) && CompareObjectWithEqualsCheck.hasObjectOperand(leftOpType, rightOpType) && CompareObjectWithEqualsCheck.neitherIsThis(leftExpression, rightExpression) && CompareObjectWithEqualsCheck.bothImplementsEqualsMethod(leftOpType, rightOpType) && CompareObjectWithEqualsCheck.neitherIsPublicStaticFinal(leftExpression, rightExpression)) {
            this.reportIssue(tree.operatorToken());
        }
    }

    private static boolean neitherIsThis(ExpressionTree leftExpression, ExpressionTree rightExpression) {
        return !ExpressionUtils.isThis((ExpressionTree)leftExpression) && !ExpressionUtils.isThis((ExpressionTree)rightExpression);
    }

    private static boolean neitherIsPublicStaticFinal(ExpressionTree leftOperand, ExpressionTree rightOperand) {
        if (CompareObjectWithEqualsCheck.compatibleTypes(leftOperand, rightOperand)) {
            return !CompareObjectWithEqualsCheck.isFinal(leftOperand) && !CompareObjectWithEqualsCheck.isFinal(rightOperand);
        }
        return true;
    }

    private static boolean compatibleTypes(ExpressionTree leftOperand, ExpressionTree rightOperand) {
        return leftOperand.symbolType().equals(rightOperand.symbolType());
    }

    private static boolean isFinal(ExpressionTree tree) {
        return CompareObjectWithEqualsCheck.symbol(tree).filter(Symbol::isFinal).isPresent();
    }

    private static Optional<Symbol> symbol(ExpressionTree tree) {
        switch (tree.kind()) {
            case IDENTIFIER: {
                return Optional.of(((IdentifierTree)tree).symbol());
            }
            case MEMBER_SELECT: {
                return Optional.of(((MemberSelectExpressionTree)tree).identifier().symbol());
            }
        }
        return Optional.empty();
    }

    private static boolean hasObjectOperand(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isObject(leftOpType) || CompareObjectWithEqualsCheck.isObject(rightOpType);
    }

    private static boolean isExcluded(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isNullComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isNumericalComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isJavaLangClassComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isObjectType(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isStringType(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isBoxedType(leftOpType, rightOpType);
    }

    private static boolean isObjectType(Type leftOpType, Type rightOpType) {
        return leftOpType.is(JAVA_LANG_OBJECT) || rightOpType.is(JAVA_LANG_OBJECT);
    }

    private static boolean isObject(Type operandType) {
        return operandType.erasure().isClass() && !operandType.symbol().isEnum();
    }

    private static boolean isNumericalComparison(Type leftOperandType, Type rightOperandType) {
        return leftOperandType.isNumerical() || rightOperandType.isNumerical();
    }

    private static boolean isJavaLangClassComparison(Type leftOpType, Type rightOpType) {
        return leftOpType.is("java.lang.Class") || rightOpType.is("java.lang.Class");
    }

    private static boolean bothImplementsEqualsMethod(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.implementsEqualsMethod(leftOpType) && CompareObjectWithEqualsCheck.implementsEqualsMethod(rightOpType);
    }

    private static boolean implementsEqualsMethod(Type type) {
        Symbol.TypeSymbol symbol = type.symbol();
        return CompareObjectWithEqualsCheck.hasEqualsMethod(symbol) || CompareObjectWithEqualsCheck.parentClassImplementsEquals(symbol);
    }

    private static boolean parentClassImplementsEquals(Symbol.TypeSymbol symbol) {
        Type superClass = symbol.superClass();
        while (superClass != null && superClass.symbol().isTypeSymbol()) {
            Symbol.TypeSymbol superClassSymbol = superClass.symbol();
            if (!superClass.is(JAVA_LANG_OBJECT) && CompareObjectWithEqualsCheck.hasEqualsMethod(superClassSymbol)) {
                return true;
            }
            superClass = superClassSymbol.superClass();
        }
        return false;
    }

    private static boolean hasEqualsMethod(Symbol.TypeSymbol symbol) {
        return symbol.lookupSymbols("equals").stream().anyMatch(arg_0 -> ((MethodMatcher)EQUALS_MATCHER).matches(arg_0));
    }
}

