/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S5411")
public class BoxedBooleanExpressionsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final MethodMatcher OPTIONAL_ORELSE = MethodMatcher.create().typeDefinition("java.util.Optional").name("orElse").addParameter(TypeCriteria.anyType());
    private static final String BOOLEAN = "java.lang.Boolean";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        if (tree.condition() != null && !this.isSafeBooleanExpression(tree.condition())) {
            this.scan(tree.initializer());
            this.scan(tree.update());
            this.scan((Tree)tree.statement());
        } else {
            super.visitForStatement(tree);
        }
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.statement());
        } else {
            super.visitWhileStatement(tree);
        }
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.statement());
        } else {
            super.visitDoWhileStatement(tree);
        }
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.thenStatement());
            this.scan((Tree)tree.elseStatement());
        } else {
            super.visitIfStatement(tree);
        }
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (!this.isSafeBooleanExpression(tree.condition())) {
            this.scan((Tree)tree.trueExpression());
            this.scan((Tree)tree.falseExpression());
        } else {
            super.visitConditionalExpression(tree);
        }
    }

    private boolean isSafeBooleanExpression(ExpressionTree tree) {
        ExpressionTree boxedBoolean = BoxedBooleanExpressionsCheck.findBoxedBoolean(tree);
        if (boxedBoolean != null) {
            this.context.reportIssue((JavaCheck)this, (Tree)boxedBoolean, "Use the primitive boolean expression here.");
            return false;
        }
        return true;
    }

    @CheckForNull
    private static ExpressionTree findBoxedBoolean(ExpressionTree tree) {
        if (tree.symbolType().is(BOOLEAN) && !BoxedBooleanExpressionsCheck.isOptionalInvocation(tree)) {
            return tree;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            return BoxedBooleanExpressionsCheck.findBoxedBoolean(((UnaryExpressionTree)tree).expression());
        }
        if (tree instanceof BinaryExpressionTree) {
            BinaryExpressionTree expr = (BinaryExpressionTree)tree;
            if (BoxedBooleanExpressionsCheck.findBoxedBoolean(expr.leftOperand()) != null && expr.rightOperand().symbolType().isPrimitive(Type.Primitives.BOOLEAN)) {
                return expr.leftOperand();
            }
            if (BoxedBooleanExpressionsCheck.findBoxedBoolean(expr.rightOperand()) != null && expr.leftOperand().symbolType().isPrimitive(Type.Primitives.BOOLEAN) && !BoxedBooleanExpressionsCheck.isNullCheck(expr.leftOperand())) {
                return expr.rightOperand();
            }
        }
        return null;
    }

    private static boolean isNullCheck(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO, Tree.Kind.EQUAL_TO})) {
            BinaryExpressionTree expr = (BinaryExpressionTree)tree;
            return expr.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || expr.rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
        return false;
    }

    private static boolean isOptionalInvocation(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            return OPTIONAL_ORELSE.matches(mit) && !((ExpressionTree)mit.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
        return false;
    }
}

