/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3415")
public class AssertionArgumentOrderCheck
extends AbstractMethodDetection {
    private static final String ORG_JUNIT_ASSERT = "org.junit.Assert";
    private static final String ORG_JUNIT5_ASSERTIONS = "org.junit.jupiter.api.Assertions";
    private static final Tree.Kind[] LITERAL_KINDS = new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL};
    private static final String MESSAGE = "Swap these 2 arguments so they are in the correct order: expected value, actual value.";
    private static final MethodMatcherCollection COLLECTION_CREATION_CALL = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.util.Collections").name(NameCriteria.startsWith((String)"singleton")).withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.Collections").name(NameCriteria.startsWith((String)"empty")).withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.Arrays").name("asList").withAnyParameters()});

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(ORG_JUNIT_ASSERT).name("assertEquals").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT_ASSERT).name("assertSame").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT_ASSERT).name("assertNotSame").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertArrayEquals").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertEquals").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertIterableEquals").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertLinesMatch").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertNotEquals").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertNotSame").withAnyParameters(), MethodMatcher.create().typeDefinition(ORG_JUNIT5_ASSERTIONS).name("assertSame").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().owner().type().is(ORG_JUNIT5_ASSERTIONS)) {
            this.checkArguments((Tree)mit.arguments().get(0), (ExpressionTree)mit.arguments().get(1));
        } else {
            ExpressionTree argToCheck = AssertionArgumentOrderCheck.getActualArgument(mit);
            this.checkArguments(AssertionArgumentOrderCheck.previousArg(argToCheck, mit), argToCheck);
        }
    }

    private void checkArguments(Tree expectedArgument, ExpressionTree actualArgument) {
        if (AssertionArgumentOrderCheck.isConstant((Tree)actualArgument) || AssertionArgumentOrderCheck.isNewArrayWithConstants(actualArgument) || AssertionArgumentOrderCheck.isCollectionCreationWithConstants(actualArgument)) {
            List<JavaFileScannerContext.Location> secondaries = Collections.singletonList(new JavaFileScannerContext.Location("", expectedArgument));
            this.context.reportIssue((JavaCheck)this, (Tree)actualArgument, MESSAGE, secondaries, null);
        }
    }

    private static boolean isNewArrayWithConstants(ExpressionTree actualArgument) {
        if (actualArgument.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            NewArrayTree newArrayTree = (NewArrayTree)actualArgument;
            return newArrayTree.initializers().stream().allMatch(AssertionArgumentOrderCheck::isConstant);
        }
        return false;
    }

    private static boolean isCollectionCreationWithConstants(ExpressionTree actualArgument) {
        if (actualArgument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)actualArgument;
            return COLLECTION_CREATION_CALL.anyMatch(mit) && mit.arguments().stream().allMatch(AssertionArgumentOrderCheck::isConstant);
        }
        return false;
    }

    private static Tree previousArg(ExpressionTree argToCheck, MethodInvocationTree mit) {
        return (Tree)mit.arguments().get(mit.arguments().indexOf((Object)argToCheck) - 1);
    }

    private static ExpressionTree getActualArgument(MethodInvocationTree mit) {
        int arity = mit.arguments().size();
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(arity - 1);
        if (arity > 2 && (arity == 4 || ((Symbol.MethodSymbol)mit.symbol()).parameterTypes().stream().allMatch(AssertionArgumentOrderCheck::isDoubleOrFloat))) {
            arg = (ExpressionTree)mit.arguments().get(arity - 2);
        }
        return arg;
    }

    private static boolean isDoubleOrFloat(Type type) {
        return type.isPrimitive(Type.Primitives.DOUBLE) || type.isPrimitive(Type.Primitives.FLOAT);
    }

    private static boolean isConstant(Tree argToCheck) {
        return argToCheck.is(LITERAL_KINDS) || argToCheck.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && AssertionArgumentOrderCheck.isStaticFinal(((IdentifierTree)argToCheck).symbol()) || argToCheck.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && AssertionArgumentOrderCheck.isStaticFinal(((MemberSelectExpressionTree)argToCheck).identifier().symbol());
    }

    private static boolean isStaticFinal(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }
}

