/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1188")
public class AnonymousClassesTooBigCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="Max", description="Maximum allowed lines in an anonymous class/lambda", defaultValue="20")
    public int max = 20;
    private JavaFileScannerContext context;
    private boolean isEnumConstantBody;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.isEnumConstantBody = false;
        this.scan((Tree)context.getTree());
    }

    public void visitNewClass(NewClassTree tree) {
        int lines;
        if (tree.classBody() != null && !this.isEnumConstantBody && (lines = AnonymousClassesTooBigCheck.getNumberOfLines((Tree)tree.classBody())) > this.max) {
            this.context.reportIssue((JavaCheck)this, (Tree)tree.newKeyword(), (Tree)tree.identifier(), "Reduce this anonymous class number of lines from " + lines + " to at most " + this.max + ", or make it a named class.");
        }
        this.isEnumConstantBody = false;
        super.visitNewClass(tree);
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.isEnumConstantBody = true;
        super.visitEnumConstant(tree);
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        int lines = AnonymousClassesTooBigCheck.getNumberOfLines((Tree)lambdaExpressionTree);
        if (lines > this.max) {
            SyntaxToken firstToken = lambdaExpressionTree.firstToken();
            SyntaxToken lastSyntaxToken = lambdaExpressionTree.lastToken();
            JavaFileScannerContext.Location lastTokenLocation = new JavaFileScannerContext.Location(lines + " lines", (Tree)lastSyntaxToken);
            this.context.reportIssue((JavaCheck)this, (Tree)firstToken, (Tree)lambdaExpressionTree.arrowToken(), "Reduce this lambda expression number of lines from " + lines + " to at most " + this.max + ".", (List)Lists.newArrayList((Object[])new JavaFileScannerContext.Location[]{lastTokenLocation}), null);
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    private static int getNumberOfLines(Tree tree) {
        return new LinesOfCodeVisitor().linesOfCode(tree);
    }
}

