/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractPrintfChecker
extends AbstractMethodDetection {
    protected static final String JAVA_LANG_STRING = "java.lang.String";
    protected static final String JAVA_UTIL_LOGGING_LOGGER = "java.util.logging.Logger";
    protected static final String ORG_APACHE_LOGGING_LOG4J_LOGGER = "org.apache.logging.log4j.Logger";
    private static final Pattern PRINTF_PARAM_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final String PRINTF_METHOD_NAME = "printf";
    private static final String FORMAT_METHOD_NAME = "format";
    protected static final List<String> LEVELS = Arrays.asList("debug", "error", "info", "trace", "warn", "fatal");
    protected static final MethodMatcher MESSAGE_FORMAT = MethodMatcher.create().typeDefinition("java.text.MessageFormat").name("format").withAnyParameters();
    protected static final MethodMatcher JAVA_UTIL_LOGGER = MethodMatcher.create().typeDefinition("java.util.logging.Logger").name("log").addParameter("java.util.logging.Level").addParameter("java.lang.String").addParameter(TypeCriteria.anyType());
    protected static final Pattern MESSAGE_FORMAT_PATTERN = Pattern.compile("\\{(?<index>\\d+)(?<type>,\\w+)?(?<style>,[^}]*)?\\}");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ArrayList<MethodMatcher> matchers = new ArrayList<MethodMatcher>(AbstractPrintfChecker.slf4jMethods());
        matchers.addAll(AbstractPrintfChecker.log4jMethods());
        matchers.addAll(Arrays.asList(MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name(FORMAT_METHOD_NAME).withAnyParameters(), MethodMatcher.create().typeDefinition("java.util.Formatter").name(FORMAT_METHOD_NAME).withAnyParameters(), MethodMatcher.create().typeDefinition("java.io.PrintStream").name(FORMAT_METHOD_NAME).withAnyParameters(), MethodMatcher.create().typeDefinition("java.io.PrintStream").name(PRINTF_METHOD_NAME).withAnyParameters(), MethodMatcher.create().typeDefinition("java.io.PrintWriter").name(FORMAT_METHOD_NAME).withAnyParameters(), MethodMatcher.create().typeDefinition("java.io.PrintWriter").name(PRINTF_METHOD_NAME).withAnyParameters(), MESSAGE_FORMAT, JAVA_UTIL_LOGGER));
        return matchers;
    }

    private static Collection<MethodMatcher> slf4jMethods() {
        return LEVELS.stream().map(l -> MethodMatcher.create().typeDefinition("org.slf4j.Logger").name(l).withAnyParameters()).collect(Collectors.toList());
    }

    private static Collection<MethodMatcher> log4jMethods() {
        ArrayList<MethodMatcher> matchers = new ArrayList<MethodMatcher>();
        matchers.add(MethodMatcher.create().typeDefinition(ORG_APACHE_LOGGING_LOG4J_LOGGER).name(PRINTF_METHOD_NAME).withAnyParameters());
        matchers.add(MethodMatcher.create().typeDefinition(ORG_APACHE_LOGGING_LOG4J_LOGGER).name("log").withAnyParameters());
        matchers.addAll(LEVELS.stream().map(l -> MethodMatcher.create().typeDefinition(ORG_APACHE_LOGGING_LOG4J_LOGGER).name(l).withAnyParameters()).collect(Collectors.toList()));
        return matchers;
    }

    protected final void checkFormatting(MethodInvocationTree mit, boolean isMessageFormat) {
        List args;
        ExpressionTree formatTree;
        Arguments arguments = mit.arguments();
        if (arguments.stream().map(ExpressionTree::symbolType).anyMatch(Type::isUnknown)) {
            return;
        }
        if (((ExpressionTree)arguments.get(0)).symbolType().is(JAVA_LANG_STRING)) {
            formatTree = (ExpressionTree)arguments.get(0);
            args = arguments.subList(1, arguments.size());
        } else {
            if (arguments.size() < 2) {
                return;
            }
            formatTree = (ExpressionTree)arguments.get(1);
            args = arguments.subList(2, arguments.size());
        }
        if (formatTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String formatString = LiteralUtils.trimQuotes((String)((LiteralTree)formatTree).value());
            if (mit.symbol().owner().type().is(ORG_APACHE_LOGGING_LOG4J_LOGGER)) {
                isMessageFormat = formatString.contains("{}");
            }
            if (isMessageFormat) {
                this.handleMessageFormat(mit, formatString, args);
            } else {
                this.handlePrintfFormat(mit, formatString, args);
            }
        } else {
            this.handleOtherFormatTree(mit, formatTree);
        }
    }

    protected abstract void handlePrintfFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleMessageFormat(MethodInvocationTree var1, String var2, List<ExpressionTree> var3);

    protected abstract void handleOtherFormatTree(MethodInvocationTree var1, ExpressionTree var2);

    protected static boolean isNewArrayWithInitializers(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && ((NewArrayTree)expression).openBraceToken() != null;
    }

    protected static String cleanupDoubleQuote(String formatString) {
        return formatString.replaceAll("''", "");
    }

    protected static Set<Integer> getMessageFormatIndexes(String formatString, MethodInvocationTree mit) {
        if (LEVELS.contains(mit.symbol().name()) || formatString.contains("{}")) {
            return IntStream.range(0, StringUtils.countMatches((String)formatString, (String)"{}")).boxed().collect(Collectors.toSet());
        }
        Matcher matcher = MESSAGE_FORMAT_PATTERN.matcher(formatString);
        HashSet<Integer> result = new HashSet<Integer>();
        while (matcher.find()) {
            if (!AbstractPrintfChecker.isMessageFormatPattern(formatString, matcher.start())) continue;
            result.add(Integer.parseInt(matcher.group("index")));
        }
        return result;
    }

    private static boolean isMessageFormatPattern(String formatString, int start) {
        return start == 0 || formatString.charAt(start - 1) != '\'' || StringUtils.countMatches((String)formatString.substring(0, start), (String)"'") % 2 == 0;
    }

    protected List<String> getParameters(String formatString, MethodInvocationTree mit) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = PRINTF_PARAM_PATTERN.matcher(formatString);
        while (matcher.find()) {
            if (AbstractPrintfChecker.firstArgumentIsLT(params, matcher.group(2))) {
                this.reportMissingPrevious(mit);
                continue;
            }
            StringBuilder param = new StringBuilder();
            for (int groupIndex : new int[]{1, 2, 5, 6}) {
                if (matcher.group(groupIndex) == null) continue;
                param.append(matcher.group(groupIndex));
            }
            String specifier = param.toString();
            if ("%".equals(specifier)) continue;
            params.add(specifier);
        }
        return params;
    }

    protected void reportMissingPrevious(MethodInvocationTree mit) {
    }

    protected static Integer getIndex(String param) {
        return Integer.valueOf(param.substring(0, param.indexOf(36)));
    }

    protected static void cleanupLineSeparator(List<String> params) {
        Iterator<String> iter = params.iterator();
        while (iter.hasNext()) {
            String param = iter.next();
            if (!"n".equals(param)) continue;
            iter.remove();
        }
    }

    protected static Set<Integer> argIndexes(List<String> params) {
        int index = 0;
        HashSet<Integer> result = new HashSet<Integer>();
        for (String rawParam : params) {
            if (rawParam.contains("$")) {
                result.add(AbstractPrintfChecker.getIndex(rawParam));
                continue;
            }
            if (rawParam.charAt(0) == '<') continue;
            result.add(++index);
        }
        return result;
    }

    private static boolean firstArgumentIsLT(List<String> params, @Nullable String group) {
        return params.isEmpty() && group != null && group.length() > 0 && group.charAt(0) == '<';
    }
}

