/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.core;

import com.sonar.sslr.api.Token;

class TokenLocation {
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;

    TokenLocation(Token token) {
        this.startLine = token.getLine();
        this.startCharacter = token.getColumn();
        String[] lines = token.getOriginalValue().split("\r\n|\n|\r", -1);
        if (lines.length > 1) {
            this.endLine = token.getLine() + lines.length - 1;
            this.endCharacter = lines[lines.length - 1].length();
        } else {
            this.endLine = this.startLine;
            this.endCharacter = this.startCharacter + token.getOriginalValue().length();
        }
    }

    int startLine() {
        return this.startLine;
    }

    int startCharacter() {
        return this.startCharacter;
    }

    int endLine() {
        return this.endLine;
    }

    int endCharacter() {
        return this.endCharacter;
    }
}

