/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;

@Rule(key="S5264")
public class ObjectWithAlternativeContentCheck
extends AbstractPageCheck {
    private TagNode object;

    @Override
    public void startDocument(List<Node> nodes) {
        this.object = null;
    }

    @Override
    public void startElement(TagNode node) {
        this.object = ObjectWithAlternativeContentCheck.isObject(node) ? node : null;
    }

    @Override
    public void endElement(TagNode node) {
        if (ObjectWithAlternativeContentCheck.isObject(node) && this.object != null) {
            this.createViolation(this.object, "Add an accessible content to this \"<object>\" tag.");
            this.object = null;
        }
    }

    @Override
    public void characters(TextNode textNode) {
        if (!textNode.isBlank()) {
            this.object = null;
        }
    }

    private static boolean isObject(TagNode node) {
        return "OBJECT".equalsIgnoreCase(node.getNodeName());
    }
}

