/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5255")
public class IndistinguishableSimilarElementsCheck
extends AbstractPageCheck {
    private static final List<String> LANDMARK_ROLES = Arrays.asList("BANNER", "COMPLEMENTARY", "CONTENTINFO", "FORM", "MAIN", "NAVIGATION", "SEARCH", "APPLICATION");
    private List<TagNode> navs = new LinkedList<TagNode>();
    private List<TagNode> asides = new LinkedList<TagNode>();
    private List<TagNode> elements = new LinkedList<TagNode>();

    @Override
    public void startDocument(List<Node> nodes) {
        this.navs.clear();
        this.asides.clear();
        this.elements.clear();
    }

    @Override
    public void endDocument() {
        this.raiseViolationOnMissingAriaLabel(this.navs);
        this.navs.clear();
        this.raiseViolationOnMissingAriaLabel(this.asides);
        this.asides.clear();
        this.raiseViolationOnDuplicateLandmarkRole(this.elements);
        this.elements.clear();
    }

    @Override
    public void startElement(TagNode node) {
        if (IndistinguishableSimilarElementsCheck.isNav(node)) {
            this.navs.add(node);
        } else if (IndistinguishableSimilarElementsCheck.isAside(node)) {
            this.asides.add(node);
        } else if (IndistinguishableSimilarElementsCheck.hasLandmarkRole(node)) {
            this.elements.add(node);
        }
    }

    private void raiseViolationOnMissingAriaLabel(List<TagNode> nodes) {
        if (nodes.size() > 1) {
            nodes.stream().filter(node -> !IndistinguishableSimilarElementsCheck.hasAriaLabel(node)).forEach(node -> this.createViolation((Node)node, "Add an \"aria-label\" or \"aria-labbelledby\" attribute to this element."));
        }
    }

    private void raiseViolationOnDuplicateLandmarkRole(List<TagNode> nodes) {
        Map<String, List<TagNode>> matched = nodes.stream().collect(Collectors.groupingBy(node -> node.getAttribute("ROLE").toUpperCase(Locale.ROOT)));
        for (List<TagNode> matches : matched.values()) {
            List labeless = matches.stream().filter(match -> !IndistinguishableSimilarElementsCheck.hasAriaLabel(match)).collect(Collectors.toList());
            if (labeless.size() <= 1 && matches.size() <= 1) continue;
            for (TagNode node2 : labeless) {
                this.createViolation(node2, "Add an \"aria-label\" or \"aria-labbelledby\" attribute to this element.");
            }
        }
    }

    private static boolean isNav(TagNode node) {
        return "NAV".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isAside(TagNode node) {
        return "ASIDE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasLandmarkRole(TagNode node) {
        return LANDMARK_ROLES.stream().anyMatch(role -> role.equalsIgnoreCase(node.getPropertyValue("ROLE")));
    }

    private static boolean hasAriaLabel(TagNode node) {
        return node.hasProperty("ARIA-LABEL") || node.hasProperty("ARIA-LABELLEDBY");
    }
}

