/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S1827")
public class DeprecatedAttributesInHtml5Check
extends AbstractPageCheck {
    private static final Map<String, Set<String>> DEPRECATED;

    private static void put(String key, String ... values) {
        DEPRECATED.put(key, new HashSet<String>(Arrays.asList(values)));
    }

    @Override
    public void startElement(TagNode element) {
        String nodeName = element.getNodeName();
        String elementName = nodeName.toLowerCase(Locale.ROOT);
        Set<String> deprecatedAttributes = DEPRECATED.get(elementName);
        if (deprecatedAttributes != null) {
            List<Attribute> attributes = element.getAttributes();
            for (Attribute attribute : attributes) {
                if (!DeprecatedAttributesInHtml5Check.isDeprecated(element, deprecatedAttributes, DeprecatedAttributesInHtml5Check.getOriginalAttributeName(attribute.getName()), attribute.getValue().toLowerCase(Locale.ROOT))) continue;
                this.createViolation(element, "Remove this deprecated \"" + attribute.getName() + "\" attribute.");
            }
        }
    }

    private static boolean isDeprecated(TagNode element, Set<String> deprecatedAttributes, String attributeName, String attributeValue) {
        String elementName = element.getNodeName().toLowerCase(Locale.ROOT);
        if ("img".equals(elementName) && "border".equals(attributeName)) {
            return !"0".equals(attributeValue);
        }
        if ("script".equals(elementName) && "language".equals(attributeName)) {
            return !"javascript".equals(attributeValue);
        }
        if ("a".equals(elementName) && "name".equals(attributeName)) {
            String id = element.getPropertyValue("id");
            return id == null || id.isEmpty() || !id.equals(attributeValue);
        }
        return deprecatedAttributes.contains(attributeName);
    }

    private static String getOriginalAttributeName(String attributeName) {
        String attributeNameLower = attributeName.toLowerCase(Locale.ENGLISH);
        if (attributeNameLower.startsWith("[attr.") && attributeNameLower.endsWith("]")) {
            return attributeNameLower.substring("[attr.".length(), attributeName.length() - 1);
        }
        if (attributeNameLower.startsWith("[") && attributeNameLower.endsWith("]")) {
            return attributeNameLower.substring(1, attributeName.length() - 1);
        }
        return attributeNameLower;
    }

    static {
        String align = "align";
        String background = "background";
        String bgcolor = "bgcolor";
        String vspace = "vspace";
        String width = "width";
        String charoff = "charoff";
        String hspace = "hspace";
        String dataformatas = "dataformatas";
        String datafld = "datafld";
        String datasrc = "datasrc";
        String compact = "compact";
        String border = "border";
        String valign = "valign";
        DEPRECATED = new HashMap<String, Set<String>>();
        DeprecatedAttributesInHtml5Check.put("a", "charset", "coords", "datafld", "datasrc", "methods", "name", "shape", "urn");
        DeprecatedAttributesInHtml5Check.put("applet", "datafld", "datasrc");
        DeprecatedAttributesInHtml5Check.put("area", "nohref");
        DeprecatedAttributesInHtml5Check.put("body", "alink", "background", "bgcolor", "link", "marginbottom", "marginheight", "marginleft", "marginright", "margintop", "marginwidth", "text", "vlink");
        DeprecatedAttributesInHtml5Check.put("br", "clear");
        DeprecatedAttributesInHtml5Check.put("button", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("caption", "align");
        DeprecatedAttributesInHtml5Check.put("col", "align", "char", "charoff", "valign", "width");
        DeprecatedAttributesInHtml5Check.put("div", "align", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("dl", "compact");
        DeprecatedAttributesInHtml5Check.put("embed", "align", "hspace", "name", "vspace");
        DeprecatedAttributesInHtml5Check.put("fieldset", "datafld");
        DeprecatedAttributesInHtml5Check.put("form", "accept");
        DeprecatedAttributesInHtml5Check.put("frame", "datafld", "datasrc");
        DeprecatedAttributesInHtml5Check.put("h1", "align");
        DeprecatedAttributesInHtml5Check.put("h2", "align");
        DeprecatedAttributesInHtml5Check.put("h3", "align");
        DeprecatedAttributesInHtml5Check.put("h4", "align");
        DeprecatedAttributesInHtml5Check.put("h5", "align");
        DeprecatedAttributesInHtml5Check.put("h6", "align");
        DeprecatedAttributesInHtml5Check.put("head", "profile");
        DeprecatedAttributesInHtml5Check.put("hr", "align", "color", "noshade", "size", "width");
        DeprecatedAttributesInHtml5Check.put("html", "version");
        DeprecatedAttributesInHtml5Check.put("iframe", "align", "allowtransparency", "datafld", "datasrc", "frameborder", "hspace", "marginheight", "marginwidth", "scrolling", "vspace");
        DeprecatedAttributesInHtml5Check.put("img", "align", "border", "datafld", "datasrc", "hspace", "lowsrc", "name", "vspace");
        DeprecatedAttributesInHtml5Check.put("input", "align", "datafld", "dataformatas", "datasrc", "hspace", "ismap", "usemap", "vspace");
        DeprecatedAttributesInHtml5Check.put("label", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("legend", "align", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("li", "type");
        DeprecatedAttributesInHtml5Check.put("link", "charset", "methods", "target", "urn");
        DeprecatedAttributesInHtml5Check.put("marquee", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("meta", "scheme");
        DeprecatedAttributesInHtml5Check.put("object", "align", "archive", "border", "classid", "code", "codebase", "codetype", "datafld", "dataformatas", "datasrc", "declare", "hspace", "standby", "vspace");
        DeprecatedAttributesInHtml5Check.put("ol", "compact");
        DeprecatedAttributesInHtml5Check.put("option", "datafld", "dataformatas", "datasrc", "name");
        DeprecatedAttributesInHtml5Check.put("p", "align");
        DeprecatedAttributesInHtml5Check.put("param", "datafld", "type", "valuetype");
        DeprecatedAttributesInHtml5Check.put("params", "type");
        DeprecatedAttributesInHtml5Check.put("pre", "width");
        DeprecatedAttributesInHtml5Check.put("script", "event", "for", "language");
        DeprecatedAttributesInHtml5Check.put("select", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("span", "datafld", "dataformatas", "datasrc");
        DeprecatedAttributesInHtml5Check.put("table", "align", "background", "bgcolor", "bordercolor", "cellpadding", "cellspacing", "dataformatas", "datapagesize", "datasrc", "frame", "rules", "summary", "width");
        DeprecatedAttributesInHtml5Check.put("text", "body");
        DeprecatedAttributesInHtml5Check.put("textarea", "datafld", "datasrc");
        DeprecatedAttributesInHtml5Check.put("tbody", "align", "background", "char", "charoff", "valign");
        DeprecatedAttributesInHtml5Check.put("thead", "align", "background", "bgcolor", "char", "charoff", "valign");
        DeprecatedAttributesInHtml5Check.put("tfoot", "align", "background", "char", "charoff", "valign");
        DeprecatedAttributesInHtml5Check.put("td", "align", "axis", "background", "bgcolor", "char", "charoff", "height", "nowrap", "scope", "valign", "width");
        DeprecatedAttributesInHtml5Check.put("th", "align", "axis", "background", "bgcolor", "char", "charoff", "height", "nowrap", "valign", "width");
        DeprecatedAttributesInHtml5Check.put("tr", "align", "background", "bgcolor", "char", "charoff", "valign");
        DeprecatedAttributesInHtml5Check.put("ul", "compact", "type");
    }
}

