/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.coding;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="DoubleQuotesCheck")
public class DoubleQuotesCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode element) {
        for (Attribute a : element.getAttributes()) {
            if (a.getValue() == null || a.getValue().trim().length() <= 0 || !DoubleQuotesCheck.isSingleQuoteAttribute(a)) continue;
            this.createViolation(element.getStartLinePosition(), "Use double quotes instead of single ones.");
            break;
        }
    }

    private static boolean isSingleQuoteAttribute(Attribute a) {
        return a.isSingleQuoted() && !StringUtils.contains(a.getValue(), '\"');
    }
}

