/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.dag.Node;

public class DirectAcyclicGraph {
    private Map<Object, Node> registeredObjects = new HashMap<Object, Node>();
    private List<Node> nodes = new ArrayList<Node>();

    public DirectAcyclicGraph(Object ... objects) {
        for (Object object : objects) {
            this.add(object, new Object[0]);
        }
    }

    public Node add(Object object, Object ... dependencies) {
        Node node = this.registeredObjects.get(object);
        if (node == null) {
            node = new Node(object);
            this.nodes.add(node);
            this.registeredObjects.put(object, node);
        }
        for (Object dependency : dependencies) {
            Node depNode = this.add(dependency, new Object[0]);
            node.addDependency(depNode);
        }
        return node;
    }

    public List sort() {
        this.sortNodes();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Node node : this.nodes) {
            result.add(node.getObject());
        }
        return result;
    }

    private List<Node> sortNodes() {
        this.verify();
        Collections.sort(this.nodes);
        return this.nodes;
    }

    private void verify() {
        for (Node node : this.nodes) {
            node.reset();
        }
        for (Node node : this.nodes) {
            for (Node dep : node.getDependencies()) {
                if (this.nodes.contains(dep)) continue;
                throw new SonarException("A dependent node (" + String.valueOf(dep) + ") of  (" + String.valueOf(node) + ") was not included in the nodes list.");
            }
            node.resolveOrder();
        }
    }
}

