/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.content.Intent;
import android.os.Bundle;
import android.util.SparseArray;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.BillingRequests;
import org.solovyev.android.checkout.Checkout;
import org.solovyev.android.checkout.IntentStarter;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseFlow;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.RequestListenerWrapper;
import org.solovyev.android.checkout.Sku;

public abstract class UiCheckout
extends Checkout {
    static final int DEFAULT_REQUEST_CODE = 51966;
    @Nonnull
    private final SparseArray<PurchaseFlow> mFlows = new SparseArray();

    protected UiCheckout(@Nonnull Object tag, @Nonnull Billing billing) {
        super(tag, billing);
    }

    @Override
    public void stop() {
        this.mFlows.clear();
        super.stop();
    }

    public void createPurchaseFlow(@Nonnull RequestListener<Purchase> listener) {
        this.createPurchaseFlow(51966, listener);
    }

    public void createPurchaseFlow(int requestCode, @Nonnull RequestListener<Purchase> listener) {
        this.createPurchaseFlow(requestCode, listener, false);
    }

    public void destroyPurchaseFlow() {
        this.destroyPurchaseFlow(51966);
    }

    public void destroyPurchaseFlow(int requestCode) {
        PurchaseFlow flow = (PurchaseFlow)this.mFlows.get(requestCode);
        if (flow == null) {
            return;
        }
        this.mFlows.delete(requestCode);
        flow.cancel();
    }

    @Nonnull
    public PurchaseFlow getPurchaseFlow() {
        return this.getPurchaseFlow(51966);
    }

    @Nonnull
    public PurchaseFlow getPurchaseFlow(int requestCode) {
        PurchaseFlow flow = (PurchaseFlow)this.mFlows.get(requestCode);
        if (flow == null) {
            throw new IllegalArgumentException("Purchase flow doesn't exist. Have you forgotten to create it?");
        }
        return flow;
    }

    @Nonnull
    public PurchaseFlow createOneShotPurchaseFlow(@Nonnull RequestListener<Purchase> listener) {
        return this.createOneShotPurchaseFlow(51966, listener);
    }

    @Nonnull
    public PurchaseFlow createOneShotPurchaseFlow(int requestCode, @Nonnull RequestListener<Purchase> listener) {
        return this.createPurchaseFlow(requestCode, listener, true);
    }

    @Nonnull
    private PurchaseFlow createPurchaseFlow(int requestCode, @Nonnull RequestListener<Purchase> listener, boolean oneShot) {
        PurchaseFlow flow = (PurchaseFlow)this.mFlows.get(requestCode);
        if (flow != null) {
            throw new IllegalArgumentException("Purchase flow associated with requestCode=" + requestCode + " already exists");
        }
        if (oneShot) {
            listener = new OneShotRequestListener(listener, requestCode);
        }
        flow = this.mBilling.createPurchaseFlow(this.makeIntentStarter(), requestCode, listener);
        this.mFlows.append(requestCode, (Object)flow);
        return flow;
    }

    @Nonnull
    protected abstract IntentStarter makeIntentStarter();

    public void startPurchaseFlow(String product, String sku, @Nullable String payload, RequestListener<Purchase> listener) {
        this.startPurchaseFlow(product, sku, payload, null, listener);
    }

    public void startPurchaseFlow(final String product, final String sku, final @Nullable String payload, final @Nullable Bundle extraParams, RequestListener<Purchase> listener) {
        this.createOneShotPurchaseFlow(listener);
        this.whenReady(new Checkout.EmptyListener(){

            @Override
            public void onReady(@Nonnull BillingRequests requests) {
                requests.purchase(product, sku, payload, extraParams, UiCheckout.this.getPurchaseFlow());
            }
        });
    }

    public void startPurchaseFlow(Sku sku, @Nullable String payload, RequestListener<Purchase> listener) {
        this.startPurchaseFlow(sku, payload, null, listener);
    }

    public void startPurchaseFlow(Sku sku, @Nullable String payload, @Nullable Bundle extraParams, RequestListener<Purchase> listener) {
        this.startPurchaseFlow(sku.id.product, sku.id.code, payload, extraParams, listener);
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        PurchaseFlow flow = (PurchaseFlow)this.mFlows.get(requestCode);
        if (flow == null) {
            Billing.warning("Purchase flow doesn't exist for requestCode=" + requestCode + ". Have you forgotten to create it?");
            return false;
        }
        flow.onActivityResult(requestCode, resultCode, data);
        return true;
    }

    private class OneShotRequestListener
    extends RequestListenerWrapper<Purchase> {
        private final int mRequestCode;

        public OneShotRequestListener(RequestListener<Purchase> listener, int requestCode) {
            super(listener);
            this.mRequestCode = requestCode;
        }

        @Override
        public void onError(int response, @Nonnull Exception e) {
            UiCheckout.this.destroyPurchaseFlow(this.mRequestCode);
            super.onError(response, e);
        }

        @Override
        public void onCancel() {
            UiCheckout.this.destroyPurchaseFlow(this.mRequestCode);
        }

        @Override
        public void onSuccess(@Nonnull Purchase result) {
            UiCheckout.this.destroyPurchaseFlow(this.mRequestCode);
            super.onSuccess(result);
        }
    }
}

