/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.json.JSONException;
import org.solovyev.android.checkout.RequestException;
import org.solovyev.android.checkout.Sku;

@Immutable
public final class Skus {
    @Nonnull
    static final String BUNDLE_LIST = "DETAILS_LIST";
    @Nonnull
    public final String product;
    @Nonnull
    public final List<Sku> list;

    Skus(@Nonnull String product, @Nonnull List<Sku> list) {
        this.product = product;
        this.list = Collections.unmodifiableList(list);
    }

    @Nonnull
    static Skus fromBundle(@Nonnull Bundle bundle, @Nonnull String product) throws RequestException {
        List<String> list = Skus.extractList(bundle);
        ArrayList<Sku> skus = new ArrayList<Sku>(list.size());
        for (String response : list) {
            try {
                skus.add(Sku.fromJson(response, product));
            }
            catch (JSONException e) {
                throw new RequestException((Exception)((Object)e));
            }
        }
        return new Skus(product, skus);
    }

    @Nonnull
    private static List<String> extractList(@Nonnull Bundle bundle) {
        ArrayList list = bundle.getStringArrayList(BUNDLE_LIST);
        return list != null ? list : Collections.emptyList();
    }

    @Nullable
    public Sku getSku(@Nonnull String sku) {
        for (Sku s : this.list) {
            if (!s.id.code.equals(sku)) continue;
            return s;
        }
        return null;
    }

    public boolean hasSku(@Nonnull String sku) {
        return this.getSku(sku) != null;
    }
}

