/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.InAppBillingService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestException;
import org.solovyev.android.checkout.RequestType;

final class PurchaseRequest
extends Request<PendingIntent> {
    @Nonnull
    private final String mProduct;
    @Nonnull
    private final String mSku;
    @Nullable
    private final String mPayload;
    @Nullable
    private final Bundle mExtraParams;

    PurchaseRequest(@Nonnull String product, @Nonnull String sku, @Nullable String payload) {
        this(product, sku, payload, null);
    }

    PurchaseRequest(@Nonnull String product, @Nonnull String sku, @Nullable String payload, @Nullable Bundle extraParams) {
        super(RequestType.PURCHASE, extraParams != null ? 6 : 3);
        this.mProduct = product;
        this.mSku = sku;
        this.mPayload = payload;
        this.mExtraParams = extraParams;
    }

    @Override
    void start(@Nonnull InAppBillingService service, @Nonnull String packageName) throws RemoteException, RequestException {
        Bundle bundle;
        String payload = this.mPayload == null ? "" : this.mPayload;
        Bundle bundle2 = bundle = this.mExtraParams != null ? service.getBuyIntentExtraParams(this.mApiVersion, packageName, this.mSku, this.mProduct, payload, this.mExtraParams) : service.getBuyIntent(this.mApiVersion, packageName, this.mSku, this.mProduct, payload);
        if (this.handleError(bundle)) {
            return;
        }
        PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("BUY_INTENT");
        Check.isNotNull(pendingIntent);
        this.onSuccess(pendingIntent);
    }

    @Override
    @Nullable
    protected String getCacheKey() {
        return null;
    }
}

