/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.BillingException;
import org.solovyev.android.checkout.CancellableRequestListener;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.IntentStarter;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseVerifier;
import org.solovyev.android.checkout.RequestListener;

public final class PurchaseFlow
implements CancellableRequestListener<PendingIntent> {
    static final String EXTRA_RESPONSE = "RESPONSE_CODE";
    static final String EXTRA_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    static final String EXTRA_PURCHASE_SIGNATURE = "INAPP_DATA_SIGNATURE";
    @Nonnull
    private final IntentStarter mIntentStarter;
    private final int mRequestCode;
    @Nonnull
    private final PurchaseVerifier mVerifier;
    @Nullable
    private RequestListener<Purchase> mListener;

    PurchaseFlow(@Nonnull IntentStarter intentStarter, int requestCode, @Nonnull RequestListener<Purchase> listener, @Nonnull PurchaseVerifier verifier) {
        this.mIntentStarter = intentStarter;
        this.mRequestCode = requestCode;
        this.mListener = listener;
        this.mVerifier = verifier;
    }

    @Override
    public void onSuccess(@Nonnull PendingIntent purchaseIntent) {
        if (this.mListener == null) {
            return;
        }
        try {
            this.mIntentStarter.startForResult(purchaseIntent.getIntentSender(), this.mRequestCode, new Intent());
        }
        catch (IntentSender.SendIntentException | RuntimeException e) {
            this.handleError((Exception)e);
        }
    }

    void onActivityResult(int requestCode, int resultCode, Intent intent) {
        try {
            Check.equals(this.mRequestCode, requestCode);
            if (intent == null) {
                this.handleError(10003);
                return;
            }
            int responseCode = intent.getIntExtra(EXTRA_RESPONSE, 0);
            if (resultCode != -1 || responseCode != 0) {
                this.handleError(responseCode);
                return;
            }
            String data = intent.getStringExtra(EXTRA_PURCHASE_DATA);
            String signature = intent.getStringExtra(EXTRA_PURCHASE_SIGNATURE);
            Check.isNotNull(data);
            Check.isNotNull(signature);
            Purchase purchase = Purchase.fromJson(data, signature);
            this.mVerifier.verify(Collections.singletonList(purchase), new VerificationListener());
        }
        catch (RuntimeException | JSONException e) {
            this.handleError((Exception)e);
        }
    }

    private void handleError(int response) {
        Billing.error("Error response: " + response + " in Purchase/ChangePurchase request");
        this.onError(response, new BillingException(response));
    }

    private void handleError(@Nonnull Exception e) {
        Billing.error("Exception in Purchase/ChangePurchase request: ", e);
        this.onError(10001, e);
    }

    @Override
    public void onError(int response, @Nonnull Exception e) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onError(response, e);
    }

    @Override
    public void cancel() {
        if (this.mListener == null) {
            return;
        }
        Billing.cancel(this.mListener);
        this.mListener = null;
    }

    private class VerificationListener
    implements RequestListener<List<Purchase>> {
        private VerificationListener() {
        }

        @Override
        public void onSuccess(@Nonnull List<Purchase> verifiedPurchases) {
            Check.isMainThread();
            if (verifiedPurchases.isEmpty()) {
                PurchaseFlow.this.handleError(10002);
                return;
            }
            if (PurchaseFlow.this.mListener == null) {
                return;
            }
            PurchaseFlow.this.mListener.onSuccess(verifiedPurchases.get(0));
        }

        @Override
        public void onError(int response, @Nonnull Exception e) {
            Check.isMainThread();
            if (response == 10001) {
                PurchaseFlow.this.handleError(e);
            } else {
                PurchaseFlow.this.handleError(response);
            }
        }
    }
}

