/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.PlayStoreListener;

class PlayStoreBroadcastReceiver
extends BroadcastReceiver {
    private static final String ACTION = "com.android.vending.billing.PURCHASES_UPDATED";
    @Nonnull
    private final Context mContext;
    @Nonnull
    private final Object mLock;
    @Nonnull
    @GuardedBy(value="mLock")
    private final List<PlayStoreListener> mListeners = new ArrayList<PlayStoreListener>();

    PlayStoreBroadcastReceiver(@Nonnull Context context, @Nonnull Object lock) {
        this.mContext = context;
        this.mLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(@Nonnull PlayStoreListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Check.isTrue(!this.mListeners.contains(listener), "Listener " + listener + " is already in the list");
            this.mListeners.add(listener);
            if (this.mListeners.size() == 1) {
                this.mContext.registerReceiver((BroadcastReceiver)this, new IntentFilter(ACTION));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(@Nonnull PlayStoreListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Check.isTrue(this.mListeners.contains(listener), "Listener " + listener + " is not in the list");
            this.mListeners.remove(listener);
            if (this.mListeners.size() == 0) {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(@Nonnull PlayStoreListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        ArrayList<PlayStoreListener> listeners;
        if (intent == null || !TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)ACTION)) {
            return;
        }
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            listeners = new ArrayList<PlayStoreListener>(this.mListeners);
        }
        for (PlayStoreListener listener : listeners) {
            listener.onPurchasesChanged();
        }
    }
}

