/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.CancellableExecutor;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.RequestListenerWrapper;

final class MainThreadRequestListener<R>
extends RequestListenerWrapper<R> {
    @Nonnull
    private final CancellableExecutor mMainThread;
    @Nullable
    private Runnable mSuccessRunnable;
    @Nullable
    private Runnable mErrorRunnable;

    MainThreadRequestListener(@Nonnull CancellableExecutor mainThread, @Nonnull RequestListener<R> listener) {
        super(listener);
        this.mMainThread = mainThread;
    }

    @Override
    public void onSuccess(final @Nonnull R result) {
        this.mSuccessRunnable = new Runnable(){

            @Override
            public void run() {
                MainThreadRequestListener.this.mListener.onSuccess(result);
            }
        };
        this.mMainThread.execute(this.mSuccessRunnable);
    }

    @Override
    public void onError(final int response, final @Nonnull Exception e) {
        this.mErrorRunnable = new Runnable(){

            @Override
            public void run() {
                MainThreadRequestListener.this.mListener.onError(response, e);
            }
        };
        this.mMainThread.execute(this.mErrorRunnable);
    }

    @Override
    public void onCancel() {
        if (this.mSuccessRunnable != null) {
            this.mMainThread.cancel(this.mSuccessRunnable);
            this.mSuccessRunnable = null;
        }
        if (this.mErrorRunnable != null) {
            this.mMainThread.cancel(this.mErrorRunnable);
            this.mErrorRunnable = null;
        }
    }
}

