/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import javax.annotation.Nonnull;
import org.solovyev.android.checkout.BaseInventory;
import org.solovyev.android.checkout.Checkout;
import org.solovyev.android.checkout.CheckoutInventory;
import org.solovyev.android.checkout.Inventory;

class FallingBackInventory
extends BaseInventory {
    @Nonnull
    private final CheckoutInventory mMainInventory;
    @Nonnull
    private final Inventory mFallbackInventory;

    public FallingBackInventory(@Nonnull Checkout checkout, @Nonnull Inventory fallbackInventory) {
        super(checkout);
        this.mMainInventory = new CheckoutInventory(checkout);
        this.mFallbackInventory = fallbackInventory;
    }

    @Override
    @Nonnull
    protected Runnable createWorker(@Nonnull BaseInventory.Task task) {
        return new Worker(task);
    }

    private class Worker
    implements Runnable {
        @Nonnull
        private final MainCallback mMainCallback = new MainCallback();
        @Nonnull
        private final FallbackCallback mFallbackCallback = new FallbackCallback();
        @Nonnull
        private final BaseInventory.Task mTask;

        Worker(BaseInventory.Task task) {
            this.mTask = task;
        }

        @Override
        public void run() {
            this.mMainCallback.load();
        }

        private class FallbackCallback
        implements Inventory.Callback {
            private FallbackCallback() {
            }

            @Override
            public void onLoaded(@Nonnull Inventory.Products products) {
                Worker.this.mTask.onDone(products);
            }

            public void load() {
                FallingBackInventory.this.mFallbackInventory.load(Worker.this.mTask.getRequest(), this);
            }
        }

        private class MainCallback
        implements Inventory.Callback {
            private MainCallback() {
            }

            @Override
            public void onLoaded(@Nonnull Inventory.Products products) {
                if (Worker.this.mTask.onMaybeDone(products)) {
                    return;
                }
                Worker.this.mFallbackCallback.load();
            }

            public void load() {
                FallingBackInventory.this.mMainInventory.load(Worker.this.mTask.getRequest(), this);
            }
        }
    }
}

