/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseVerifier;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.Security;

class DefaultPurchaseVerifier
implements PurchaseVerifier {
    static final Set<String> TEST_SKUS = new HashSet<String>(Arrays.asList("android.test.purchased", "android.test.canceled", "android.test.refunded", "android.test.item_unavailable"));
    @Nonnull
    private final String mPublicKey;

    public DefaultPurchaseVerifier(@Nonnull String publicKey) {
        this.mPublicKey = publicKey;
    }

    @Override
    public void verify(@Nonnull List<Purchase> purchases, @Nonnull RequestListener<List<Purchase>> listener) {
        ArrayList<Purchase> verifiedPurchases = new ArrayList<Purchase>(purchases.size());
        for (Purchase purchase : purchases) {
            if (TEST_SKUS.contains(purchase.sku)) {
                Billing.debug("Auto-verifying a test purchase: " + purchase);
                verifiedPurchases.add(purchase);
                continue;
            }
            if (Security.verifyPurchase(this.mPublicKey, purchase.data, purchase.signature)) {
                verifiedPurchases.add(purchase);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)purchase.signature)) {
                Billing.error("Cannot verify purchase: " + purchase + ". Signature is empty");
                continue;
            }
            Billing.error("Cannot verify purchase: " + purchase + ". Wrong signature");
        }
        listener.onSuccess(verifiedPurchases);
    }
}

