/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.BaseInventory;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.BillingRequests;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Checkout;
import org.solovyev.android.checkout.Inventory;
import org.solovyev.android.checkout.ProductTypes;
import org.solovyev.android.checkout.Purchases;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.Skus;

final class CheckoutInventory
extends BaseInventory {
    CheckoutInventory(@Nonnull Checkout checkout) {
        super(checkout);
    }

    @Override
    @Nonnull
    protected Runnable createWorker(@Nonnull BaseInventory.Task task) {
        return new Worker(task);
    }

    private class Worker
    implements Checkout.Listener,
    Runnable {
        @Nonnull
        private final BaseInventory.Task mTask;
        @GuardedBy(value="mLock")
        private int mCount;
        @GuardedBy(value="mLock")
        private final Inventory.Products mProducts = new Inventory.Products();

        Worker(BaseInventory.Task task) {
            this.mTask = task;
        }

        @Override
        public void run() {
            Check.isTrue(Thread.holdsLock(CheckoutInventory.this.mLock), "Must be synchronized");
            this.mCount = ProductTypes.ALL.size() * 3;
            CheckoutInventory.this.mCheckout.whenReady(this);
        }

        @Override
        public void onReady(@Nonnull BillingRequests requests) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReady(@Nonnull BillingRequests requests, @Nonnull String productId, boolean billingSupported) {
            Inventory.Product product = new Inventory.Product(productId, billingSupported);
            Object object = CheckoutInventory.this.mLock;
            synchronized (object) {
                this.countDown();
                this.mProducts.add(product);
                if (!this.mTask.isCancelled() && product.supported && this.mTask.getRequest().shouldLoadPurchases(productId)) {
                    this.loadPurchases(requests, product);
                } else {
                    this.countDown(1);
                }
                if (!this.mTask.isCancelled() && product.supported && this.mTask.getRequest().shouldLoadSkus(productId)) {
                    this.loadSkus(requests, product);
                } else {
                    this.countDown(1);
                }
            }
        }

        private void countDown() {
            Check.isTrue(Thread.holdsLock(CheckoutInventory.this.mLock), "Must be synchronized");
            this.countDown(1);
        }

        private void countDown(int count) {
            Check.isTrue(Thread.holdsLock(CheckoutInventory.this.mLock), "Must be synchronized");
            this.mCount -= count;
            Check.isTrue(this.mCount >= 0, "Can't be negative");
            if (this.mCount == 0) {
                this.mTask.onDone(this.mProducts);
            }
        }

        private void loadPurchases(@Nonnull BillingRequests requests, final @Nonnull Inventory.Product product) {
            requests.getAllPurchases(product.id, CheckoutInventory.this.synchronizedListener(new RequestListener<Purchases>(){

                @Override
                public void onSuccess(@Nonnull Purchases purchases) {
                    product.setPurchases(purchases.list);
                    Worker.this.countDown();
                }

                @Override
                public void onError(int response, @Nonnull Exception e) {
                    Worker.this.countDown();
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadSkus(@Nonnull BillingRequests requests, final @Nonnull Inventory.Product product) {
            List<String> skuIds = this.mTask.getRequest().getSkus(product.id);
            if (skuIds.isEmpty()) {
                Billing.warning("There are no SKUs for \"" + product.id + "\" product. No SKU information will be loaded");
                Object object = CheckoutInventory.this.mLock;
                synchronized (object) {
                    this.countDown();
                }
                return;
            }
            requests.getSkus(product.id, skuIds, CheckoutInventory.this.synchronizedListener(new RequestListener<Skus>(){

                @Override
                public void onSuccess(@Nonnull Skus skus) {
                    product.setSkus(skus.list);
                    Worker.this.countDown();
                }

                @Override
                public void onError(int response, @Nonnull Exception e) {
                    Worker.this.countDown();
                }
            }));
        }
    }
}

