/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.RequestType;

public interface Cache {
    @Nullable
    public Entry get(@Nonnull Key var1);

    public void put(@Nonnull Key var1, @Nonnull Entry var2);

    public void init();

    public void remove(@Nonnull Key var1);

    public void removeAll(int var1);

    public void clear();

    public static final class Entry {
        @Nonnull
        public final Object data;
        public final long expiresAt;

        Entry(@Nonnull Object data, long expiresAt) {
            this.data = data;
            this.expiresAt = expiresAt;
        }
    }

    public static final class Key {
        public final int type;
        @Nonnull
        public final String key;

        Key(int type, @Nonnull String key) {
            this.type = type;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            if (this.type != that.type) {
                return false;
            }
            return this.key.equals(that.key);
        }

        public int hashCode() {
            int result = this.type;
            result = 31 * result + this.key.hashCode();
            return result;
        }

        public String toString() {
            return RequestType.getCacheKeyName(this.type) + "_" + this.key;
        }
    }
}

