/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.vending.billing.InAppBillingService;
import com.android.vending.billing.InAppBillingServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.BasePurchasesRequest;
import org.solovyev.android.checkout.BillingException;
import org.solovyev.android.checkout.BillingRequests;
import org.solovyev.android.checkout.BillingSupportedRequest;
import org.solovyev.android.checkout.Cache;
import org.solovyev.android.checkout.CancellableExecutor;
import org.solovyev.android.checkout.CancellableRequestListener;
import org.solovyev.android.checkout.ChangePurchaseRequest;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Checkout;
import org.solovyev.android.checkout.ConcurrentCache;
import org.solovyev.android.checkout.ConsumePurchaseRequest;
import org.solovyev.android.checkout.DefaultLogger;
import org.solovyev.android.checkout.DefaultPurchaseVerifier;
import org.solovyev.android.checkout.EmptyLogger;
import org.solovyev.android.checkout.EmptyRequestListener;
import org.solovyev.android.checkout.GetPurchaseHistoryRequest;
import org.solovyev.android.checkout.GetPurchasesRequest;
import org.solovyev.android.checkout.GetSkuDetailsRequest;
import org.solovyev.android.checkout.IntentStarter;
import org.solovyev.android.checkout.Inventory;
import org.solovyev.android.checkout.Logger;
import org.solovyev.android.checkout.MainThread;
import org.solovyev.android.checkout.MainThreadLogger;
import org.solovyev.android.checkout.MainThreadRequestListener;
import org.solovyev.android.checkout.MapCache;
import org.solovyev.android.checkout.PendingRequests;
import org.solovyev.android.checkout.PlayStoreBroadcastReceiver;
import org.solovyev.android.checkout.PlayStoreListener;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseFlow;
import org.solovyev.android.checkout.PurchaseRequest;
import org.solovyev.android.checkout.PurchaseVerifier;
import org.solovyev.android.checkout.Purchases;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestException;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.RequestListenerWrapper;
import org.solovyev.android.checkout.RequestRunnable;
import org.solovyev.android.checkout.RequestType;
import org.solovyev.android.checkout.SafeCache;
import org.solovyev.android.checkout.SameThreadExecutor;
import org.solovyev.android.checkout.Sku;
import org.solovyev.android.checkout.Skus;

public final class Billing {
    static final int V3 = 3;
    static final int V5 = 5;
    static final int V6 = 6;
    static final int V7 = 7;
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    @Nonnull
    private static final String TAG = "Checkout";
    @Nonnull
    private static final EmptyRequestListener sEmptyListener = new EmptyRequestListener();
    @Nonnull
    private static final EnumMap<State, List<State>> sPreviousStates = new EnumMap(State.class);
    @Nonnull
    private static Logger sLogger = Billing.newLogger();
    @Nonnull
    private final Context mContext;
    @Nonnull
    private final Object mLock = new Object();
    @Nonnull
    private final StaticConfiguration mConfiguration;
    @Nonnull
    private final ConcurrentCache mCache;
    @Nonnull
    private final PendingRequests mPendingRequests = new PendingRequests();
    @Nonnull
    private final BillingRequests mRequests = this.newRequestsBuilder().withTag(null).onBackgroundThread().create();
    @Nonnull
    @GuardedBy(value="mLock")
    private final PlayStoreBroadcastReceiver mPlayStoreBroadcastReceiver;
    @Nonnull
    private final PlayStoreListener mPlayStoreListener = new PlayStoreListener(){

        @Override
        public void onPurchasesChanged() {
            Billing.this.mCache.removeAll(RequestType.GET_PURCHASES.getCacheKeyType());
        }
    };
    @Nullable
    @GuardedBy(value="mLock")
    private InAppBillingService mService;
    @Nonnull
    @GuardedBy(value="mLock")
    private State mState = State.INITIAL;
    @Nonnull
    private CancellableExecutor mMainThread;
    @Nonnull
    private Executor mBackground = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            return new Thread(r, "RequestThread");
        }
    });
    @Nonnull
    private ServiceConnector mConnector = new DefaultServiceConnector();
    @GuardedBy(value="mLock")
    private int mCheckoutCount;

    public Billing(@Nonnull Context context, @Nonnull Configuration configuration) {
        this(context, new Handler(), configuration);
        Check.isMainThread();
    }

    public Billing(@Nonnull Context context, @Nonnull Handler handler, @Nonnull Configuration configuration) {
        this.mContext = context instanceof Application ? context : context.getApplicationContext();
        this.mMainThread = new MainThread(handler);
        this.mConfiguration = new StaticConfiguration(configuration);
        Check.isNotEmpty(this.mConfiguration.getPublicKey());
        Cache cache = configuration.getCache();
        this.mCache = new ConcurrentCache(cache == null ? null : new SafeCache(cache));
        this.mPlayStoreBroadcastReceiver = new PlayStoreBroadcastReceiver(this.mContext, this.mLock);
    }

    static void waitGooglePlay() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Billing.error(e);
        }
    }

    @Nonnull
    private static <R> RequestListener<R> emptyListener() {
        return sEmptyListener;
    }

    static void error(@Nonnull String message) {
        sLogger.e(TAG, message);
    }

    static void error(@Nonnull Exception e) {
        String msg = e.getMessage();
        Billing.error(msg == null ? "" : msg, e);
    }

    static void error(@Nonnull String message, @Nonnull Exception e) {
        if (e instanceof BillingException) {
            BillingException be = (BillingException)e;
            switch (be.getResponse()) {
                case 0: 
                case 1: 
                case 2: {
                    sLogger.e(TAG, message, e);
                    break;
                }
                default: {
                    sLogger.e(TAG, message, e);
                    break;
                }
            }
        } else {
            sLogger.e(TAG, message, e);
        }
    }

    static void debug(@Nonnull String subTag, @Nonnull String message) {
        sLogger.d("Checkout/" + subTag, message);
    }

    static void debug(@Nonnull String message) {
        sLogger.d(TAG, message);
    }

    static void warning(@Nonnull String message) {
        sLogger.w(TAG, message);
    }

    public static void setLogger(@Nullable Logger logger) {
        sLogger = logger == null ? new EmptyLogger() : logger;
    }

    @Nonnull
    public static Cache newCache() {
        return new MapCache();
    }

    @Nonnull
    public static PurchaseVerifier newPurchaseVerifier(@Nonnull String publicKey) {
        return new DefaultPurchaseVerifier(publicKey);
    }

    @Nonnull
    public static Logger newLogger() {
        return new DefaultLogger();
    }

    @Nonnull
    public static Logger newMainThreadLogger(@Nonnull Logger logger) {
        return new MainThreadLogger(logger);
    }

    static void cancel(@Nonnull RequestListener<?> listener) {
        if (listener instanceof CancellableRequestListener) {
            ((CancellableRequestListener)listener).cancel();
        }
    }

    @Nonnull
    public Context getContext() {
        return this.mContext;
    }

    @Nonnull
    Configuration getConfiguration() {
        return this.mConfiguration;
    }

    @Nonnull
    ServiceConnector getConnector() {
        return this.mConnector;
    }

    void setConnector(@Nonnull ServiceConnector connector) {
        this.mConnector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setService(@Nullable InAppBillingService service, boolean connecting) {
        Object object = this.mLock;
        synchronized (object) {
            State newState;
            if (connecting) {
                if (this.mState != State.CONNECTING) {
                    if (service != null) {
                        this.mConnector.disconnect();
                    }
                    return;
                }
                newState = service == null ? State.FAILED : State.CONNECTED;
            } else {
                if (this.mState == State.INITIAL || this.mState == State.DISCONNECTED || this.mState == State.FAILED) {
                    Check.isNull(this.mService);
                    return;
                }
                if (this.mState == State.CONNECTED) {
                    this.setState(State.DISCONNECTING);
                }
                if (this.mState == State.DISCONNECTING) {
                    newState = State.DISCONNECTED;
                } else {
                    Check.isTrue(this.mState == State.CONNECTING, "Unexpected state: " + (Object)((Object)this.mState));
                    newState = State.FAILED;
                }
            }
            this.mService = service;
            this.setState(newState);
        }
    }

    void setBackground(@Nonnull Executor background) {
        this.mBackground = background;
    }

    void setMainThread(@Nonnull CancellableExecutor mainThread) {
        this.mMainThread = mainThread;
    }

    void setPurchaseVerifier(@Nonnull PurchaseVerifier purchaseVerifier) {
        this.mConfiguration.setPurchaseVerifier(purchaseVerifier);
    }

    private void executePendingRequests() {
        this.mBackground.execute(this.mPendingRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    State getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(@Nonnull State newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == newState) {
                return;
            }
            Check.isTrue(sPreviousStates.get((Object)newState).contains((Object)this.mState), "State " + (Object)((Object)newState) + " can't come right after " + (Object)((Object)this.mState) + " state");
            this.mState = newState;
            switch (this.mState) {
                case DISCONNECTING: {
                    this.mPlayStoreBroadcastReceiver.removeListener(this.mPlayStoreListener);
                    break;
                }
                case CONNECTED: {
                    this.mPlayStoreBroadcastReceiver.addListener(this.mPlayStoreListener);
                    this.executePendingRequests();
                    break;
                }
                case FAILED: {
                    Check.isTrue(!this.mPlayStoreBroadcastReceiver.contains(this.mPlayStoreListener), "Leaking the listener");
                    this.mMainThread.execute(new Runnable(){

                        @Override
                        public void run() {
                            Billing.this.mPendingRequests.onConnectionFailed();
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == State.CONNECTED) {
                this.executePendingRequests();
                return;
            }
            if (this.mState == State.CONNECTING) {
                return;
            }
            if (this.mConfiguration.isAutoConnect() && this.mCheckoutCount <= 0) {
                Billing.warning("Auto connection feature is turned on. There is no need in calling Billing.connect() manually. See Billing.Configuration.isAutoConnect");
            }
            this.setState(State.CONNECTING);
            this.mMainThread.execute(new Runnable(){

                @Override
                public void run() {
                    Billing.this.connectOnMainThread();
                }
            });
        }
    }

    private void connectOnMainThread() {
        Check.isMainThread();
        boolean connecting = this.mConnector.connect();
        if (!connecting) {
            this.setState(State.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayStoreListener(@Nonnull PlayStoreListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlayStoreBroadcastReceiver.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayStoreListener(@Nonnull PlayStoreListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlayStoreBroadcastReceiver.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == State.DISCONNECTED || this.mState == State.DISCONNECTING || this.mState == State.INITIAL) {
                return;
            }
            if (this.mState == State.FAILED) {
                this.mPendingRequests.cancelAll();
                return;
            }
            if (this.mState == State.CONNECTED) {
                this.setState(State.DISCONNECTING);
                this.mMainThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        Billing.this.disconnectOnMainThread();
                    }
                });
            } else {
                this.setState(State.DISCONNECTED);
            }
            this.mPendingRequests.cancelAll();
        }
    }

    private void disconnectOnMainThread() {
        Check.isMainThread();
        this.mConnector.disconnect();
    }

    private int runWhenConnected(@Nonnull Request request, @Nullable Object tag) {
        return this.runWhenConnected(request, null, tag);
    }

    <R> int runWhenConnected(@Nonnull Request<R> request, @Nullable RequestListener<R> listener, @Nullable Object tag) {
        if (listener != null) {
            if (this.mCache.hasCache()) {
                listener = new CachingRequestListener<R>(request, listener);
            }
            request.setListener(listener);
        }
        if (tag != null) {
            request.setTag(tag);
        }
        this.mPendingRequests.add(this.onConnectedService(request));
        this.connect();
        return request.getId();
    }

    public void cancel(int requestId) {
        this.mPendingRequests.cancel(requestId);
    }

    public void cancelAll() {
        this.mPendingRequests.cancelAll();
    }

    @Nonnull
    private RequestRunnable onConnectedService(@Nonnull Request request) {
        return new OnConnectedServiceRunnable(request);
    }

    @Nonnull
    public RequestsBuilder newRequestsBuilder() {
        return new RequestsBuilder();
    }

    @Nonnull
    public BillingRequests getRequests() {
        return this.mRequests;
    }

    @Nonnull
    public Requests getRequests(@Nullable Object tag) {
        if (tag == null) {
            return (Requests)this.getRequests();
        }
        return (Requests)new RequestsBuilder().withTag(tag).onMainThread().create();
    }

    @Nonnull
    PurchaseFlow createPurchaseFlow(@Nonnull IntentStarter intentStarter, int requestCode, @Nonnull RequestListener<Purchase> listener) {
        if (this.mCache.hasCache()) {
            listener = new RequestListenerWrapper<Purchase>(listener){

                @Override
                public void onSuccess(@Nonnull Purchase result) {
                    Billing.this.mCache.removeAll(RequestType.GET_PURCHASES.getCacheKeyType());
                    super.onSuccess(result);
                }
            };
        }
        return new PurchaseFlow(intentStarter, requestCode, (RequestListener<Purchase>)listener, this.mConfiguration.getPurchaseVerifier());
    }

    @Nonnull
    private <R> RequestListener<R> onMainThread(@Nonnull RequestListener<R> listener) {
        return new MainThreadRequestListener<R>(this.mMainThread, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCheckoutStarted() {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            ++this.mCheckoutCount;
            if (this.mCheckoutCount > 0 && this.mConfiguration.isAutoConnect()) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCheckoutStopped() {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            --this.mCheckoutCount;
            if (this.mCheckoutCount < 0) {
                this.mCheckoutCount = 0;
                Billing.warning("Billing#onCheckoutStopped is called more than Billing#onCheckoutStarted");
            }
            if (this.mCheckoutCount == 0 && this.mConfiguration.isAutoConnect()) {
                this.disconnect();
            }
        }
    }

    static {
        sPreviousStates.put(State.INITIAL, Collections.emptyList());
        sPreviousStates.put(State.CONNECTING, Arrays.asList(State.INITIAL, State.FAILED, State.DISCONNECTED, State.DISCONNECTING));
        sPreviousStates.put(State.CONNECTED, Collections.singletonList(State.CONNECTING));
        sPreviousStates.put(State.DISCONNECTING, Collections.singletonList(State.CONNECTED));
        sPreviousStates.put(State.DISCONNECTED, Arrays.asList(State.DISCONNECTING, State.CONNECTING));
        sPreviousStates.put(State.FAILED, Collections.singletonList(State.CONNECTING));
    }

    private final class DefaultServiceConnector
    implements ServiceConnector {
        @Nonnull
        private final ServiceConnection mConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                Billing.this.setService(null, false);
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                Billing.this.setService(InAppBillingServiceImpl.make(service), true);
            }
        };

        private DefaultServiceConnector() {
        }

        @Override
        public boolean connect() {
            try {
                Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
                intent.setPackage("com.android.vending");
                return Billing.this.mContext.bindService(intent, this.mConnection, 1);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public void disconnect() {
            Billing.this.mContext.unbindService(this.mConnection);
        }
    }

    private class CachingRequestListener<R>
    extends RequestListenerWrapper<R> {
        @Nonnull
        private final Request<R> mRequest;

        public CachingRequestListener(@Nonnull Request<R> request, RequestListener<R> listener) {
            super(listener);
            Check.isTrue(Billing.this.mCache.hasCache(), "Cache must exist");
            this.mRequest = request;
        }

        @Override
        public void onSuccess(@Nonnull R result) {
            String key = this.mRequest.getCacheKey();
            RequestType type = this.mRequest.getType();
            if (key != null) {
                long now = System.currentTimeMillis();
                Cache.Entry entry = new Cache.Entry(result, now + type.expiresIn);
                Billing.this.mCache.putIfNotExist(type.getCacheKey(key), entry);
            }
            switch (type) {
                case PURCHASE: 
                case CHANGE_PURCHASE: 
                case CONSUME_PURCHASE: {
                    Billing.this.mCache.removeAll(RequestType.GET_PURCHASES.getCacheKeyType());
                }
            }
            super.onSuccess(result);
        }

        @Override
        public void onError(int response, @Nonnull Exception e) {
            RequestType type = this.mRequest.getType();
            switch (type) {
                case PURCHASE: 
                case CHANGE_PURCHASE: {
                    if (response != 7) break;
                    Billing.this.mCache.removeAll(RequestType.GET_PURCHASES.getCacheKeyType());
                    break;
                }
                case CONSUME_PURCHASE: {
                    if (response != 8) break;
                    Billing.this.mCache.removeAll(RequestType.GET_PURCHASES.getCacheKeyType());
                }
            }
            super.onError(response, e);
        }
    }

    final class Requests
    implements BillingRequests {
        @Nullable
        private final Object mTag;
        private final boolean mOnMainThread;

        private Requests(Object tag, boolean onMainThread) {
            this.mTag = tag;
            this.mOnMainThread = onMainThread;
        }

        @Override
        public int isBillingSupported(@Nonnull String product) {
            return this.isBillingSupported(product, Billing.emptyListener());
        }

        @Override
        public int isBillingSupported(@Nonnull String product, int apiVersion) {
            return this.isBillingSupported(product, apiVersion, Billing.emptyListener());
        }

        @Override
        public int isBillingSupported(@Nonnull String product, int apiVersion, @Nonnull RequestListener<Object> listener) {
            Check.isNotEmpty(product);
            return Billing.this.runWhenConnected(new BillingSupportedRequest(product, apiVersion, null), this.wrapListener(listener), this.mTag);
        }

        @Override
        public int isBillingSupported(@Nonnull String product, int apiVersion, @Nonnull Bundle extraParams, @Nonnull RequestListener<Object> listener) {
            Check.isNotEmpty(product);
            return Billing.this.runWhenConnected(new BillingSupportedRequest(product, apiVersion, extraParams), this.wrapListener(listener), this.mTag);
        }

        @Override
        public int isBillingSupported(@Nonnull String product, @Nonnull RequestListener<Object> listener) {
            return this.isBillingSupported(product, 3, listener);
        }

        @Nonnull
        private <R> RequestListener<R> wrapListener(@Nonnull RequestListener<R> listener) {
            return this.mOnMainThread ? Billing.this.onMainThread(listener) : listener;
        }

        @Nonnull
        Executor getDeliveryExecutor() {
            return this.mOnMainThread ? Billing.this.mMainThread : SameThreadExecutor.INSTANCE;
        }

        @Override
        public int getPurchases(@Nonnull String product, @Nullable String continuationToken, @Nonnull RequestListener<Purchases> listener) {
            Check.isNotEmpty(product);
            return Billing.this.runWhenConnected(new GetPurchasesRequest(product, continuationToken, Billing.this.mConfiguration.getPurchaseVerifier()), this.wrapListener(listener), this.mTag);
        }

        @Override
        public int getAllPurchases(@Nonnull String product, @Nonnull RequestListener<Purchases> listener) {
            Check.isNotEmpty(product);
            GetPurchasesRequest request = new GetPurchasesRequest(product, null, Billing.this.mConfiguration.getPurchaseVerifier());
            return Billing.this.runWhenConnected(request, this.wrapListener(new GetAllPurchasesListener(request, listener)), this.mTag);
        }

        @Override
        public int getPurchaseHistory(@Nonnull String product, @Nullable String continuationToken, @Nullable Bundle extraParams, @Nonnull RequestListener<Purchases> listener) {
            Check.isNotEmpty(product);
            return Billing.this.runWhenConnected(new GetPurchaseHistoryRequest(product, continuationToken, extraParams), this.wrapListener(listener), this.mTag);
        }

        @Override
        public int getWholePurchaseHistory(@Nonnull String product, @Nullable Bundle extraParams, @Nonnull RequestListener<Purchases> listener) {
            Check.isNotEmpty(product);
            GetPurchaseHistoryRequest request = new GetPurchaseHistoryRequest(product, null, extraParams);
            return Billing.this.runWhenConnected(request, this.wrapListener(new GetWholePurchaseHistoryListener(request, listener)), this.mTag);
        }

        @Override
        public int isGetPurchaseHistorySupported(@Nonnull String product, @Nonnull RequestListener<Object> listener) {
            Check.isNotEmpty(product);
            return this.isBillingSupported(product, 6, listener);
        }

        @Override
        public int isPurchased(@Nonnull String product, @Nonnull String sku, @Nonnull RequestListener<Boolean> listener) {
            Check.isNotEmpty(sku);
            IsPurchasedListener isPurchasedListener = new IsPurchasedListener(sku, listener);
            GetPurchasesRequest request = new GetPurchasesRequest(product, null, Billing.this.mConfiguration.getPurchaseVerifier());
            isPurchasedListener.mRequest = request;
            return Billing.this.runWhenConnected(request, this.wrapListener(isPurchasedListener), this.mTag);
        }

        @Override
        public int getSkus(@Nonnull String product, @Nonnull List<String> skus, @Nonnull RequestListener<Skus> listener) {
            Check.isNotEmpty(product);
            Check.isNotEmpty(skus);
            return Billing.this.runWhenConnected(new GetSkuDetailsRequest(product, skus), this.wrapListener(listener), this.mTag);
        }

        @Override
        public int purchase(@Nonnull String product, @Nonnull String sku, @Nullable String payload, @Nonnull PurchaseFlow purchaseFlow) {
            Check.isNotEmpty(product);
            Check.isNotEmpty(sku);
            return Billing.this.runWhenConnected(new PurchaseRequest(product, sku, payload), this.wrapListener(purchaseFlow), this.mTag);
        }

        @Override
        public int purchase(@Nonnull String product, @Nonnull String sku, @Nullable String payload, @Nullable Bundle extraParams, @Nonnull PurchaseFlow purchaseFlow) {
            Check.isNotEmpty(product);
            Check.isNotEmpty(sku);
            return Billing.this.runWhenConnected(new PurchaseRequest(product, sku, payload, extraParams), this.wrapListener(purchaseFlow), this.mTag);
        }

        @Override
        public int isPurchaseWithExtraParamsSupported(@Nonnull String product, @Nonnull RequestListener<Object> listener) {
            Check.isNotEmpty(product);
            return this.isBillingSupported(product, 6, listener);
        }

        @Override
        public int changeSubscription(@Nonnull List<String> oldSkus, @Nonnull String newSku, @Nullable String payload, @Nonnull PurchaseFlow purchaseFlow) {
            Check.isNotEmpty(oldSkus);
            Check.isNotEmpty(newSku);
            return Billing.this.runWhenConnected(new ChangePurchaseRequest("subs", oldSkus, newSku, payload), this.wrapListener(purchaseFlow), this.mTag);
        }

        @Override
        public int changeSubscription(@Nonnull List<Sku> oldSkus, @Nonnull Sku newSku, @Nullable String payload, @Nonnull PurchaseFlow purchaseFlow) {
            Check.isTrue("subs".equals(newSku.id.product), "Only subscriptions can be downgraded/upgraded");
            ArrayList<String> oldSkuIds = new ArrayList<String>(oldSkus.size());
            for (Sku oldSku : oldSkus) {
                Check.isTrue(oldSku.id.product.equals(newSku.id.product), "Product type can't be changed");
                oldSkuIds.add(oldSku.id.code);
            }
            return this.changeSubscription(oldSkuIds, newSku.id.code, payload, purchaseFlow);
        }

        @Override
        public int isChangeSubscriptionSupported(RequestListener<Object> listener) {
            return this.isBillingSupported("subs", 5, listener);
        }

        @Override
        public int purchase(@Nonnull Sku sku, @Nullable String payload, @Nonnull PurchaseFlow purchaseFlow) {
            return this.purchase(sku.id.product, sku.id.code, payload, purchaseFlow);
        }

        @Override
        public int consume(@Nonnull String token, @Nonnull RequestListener<Object> listener) {
            Check.isNotEmpty(token);
            return Billing.this.runWhenConnected(new ConsumePurchaseRequest(token), this.wrapListener(listener), this.mTag);
        }

        @Override
        public void cancelAll() {
            Billing.this.mPendingRequests.cancelAll(this.mTag);
        }

        @Override
        public void cancel(int requestId) {
            Billing.this.mPendingRequests.cancel(requestId);
        }

        private abstract class BaseAllPurchasesListener
        implements CancellableRequestListener<Purchases> {
            @Nonnull
            private final RequestListener<Purchases> mListener;
            @Nonnull
            private final List<Purchase> mPurchases = new ArrayList<Purchase>();
            @Nonnull
            private BasePurchasesRequest mRequest;

            BaseAllPurchasesListener(@Nonnull BasePurchasesRequest initialRequest, RequestListener<Purchases> listener) {
                this.mRequest = initialRequest;
                this.mListener = listener;
            }

            @Override
            public void onSuccess(@Nonnull Purchases purchases) {
                this.mPurchases.addAll(purchases.list);
                String continuationToken = purchases.continuationToken;
                if (continuationToken == null) {
                    this.mListener.onSuccess(new Purchases(purchases.product, this.mPurchases, null));
                    return;
                }
                this.mRequest = this.makeContinuationRequest(this.mRequest, continuationToken);
                Billing.this.runWhenConnected(this.mRequest, Requests.this.mTag);
            }

            @Nonnull
            protected abstract BasePurchasesRequest makeContinuationRequest(@Nonnull BasePurchasesRequest var1, @Nonnull String var2);

            @Override
            public void onError(int response, @Nonnull Exception e) {
                this.mListener.onError(response, e);
            }

            @Override
            public void cancel() {
                Billing.cancel(this.mListener);
            }
        }

        private final class GetWholePurchaseHistoryListener
        extends BaseAllPurchasesListener {
            GetWholePurchaseHistoryListener(@Nonnull GetPurchaseHistoryRequest initialRequest, RequestListener<Purchases> listener) {
                super(initialRequest, listener);
            }

            @Override
            @Nonnull
            protected BasePurchasesRequest makeContinuationRequest(@Nonnull BasePurchasesRequest request, @Nonnull String continuationToken) {
                return new GetPurchaseHistoryRequest((GetPurchaseHistoryRequest)request, continuationToken);
            }
        }

        private final class GetAllPurchasesListener
        extends BaseAllPurchasesListener {
            GetAllPurchasesListener(@Nonnull GetPurchasesRequest initialRequest, RequestListener<Purchases> listener) {
                super(initialRequest, listener);
            }

            @Override
            @Nonnull
            protected GetPurchasesRequest makeContinuationRequest(@Nonnull BasePurchasesRequest request, @Nonnull String continuationToken) {
                return new GetPurchasesRequest((GetPurchasesRequest)request, continuationToken);
            }
        }

        private final class IsPurchasedListener
        implements CancellableRequestListener<Purchases> {
            @Nonnull
            private final String mSku;
            @Nonnull
            private final RequestListener<Boolean> mListener;
            @Nonnull
            private GetPurchasesRequest mRequest;

            public IsPurchasedListener(@Nonnull String sku, RequestListener<Boolean> listener) {
                this.mSku = sku;
                this.mListener = listener;
            }

            @Override
            public void onSuccess(@Nonnull Purchases purchases) {
                Purchase purchase = purchases.getPurchase(this.mSku);
                if (purchase != null) {
                    this.mListener.onSuccess(purchase.state == Purchase.State.PURCHASED);
                    return;
                }
                if (purchases.continuationToken == null) {
                    this.mListener.onSuccess(false);
                    return;
                }
                this.mRequest = new GetPurchasesRequest(this.mRequest, purchases.continuationToken);
                Billing.this.runWhenConnected(this.mRequest, Requests.this.mTag);
            }

            @Override
            public void onError(int response, @Nonnull Exception e) {
                this.mListener.onError(response, e);
            }

            @Override
            public void cancel() {
                Billing.cancel(this.mListener);
            }
        }
    }

    public final class RequestsBuilder {
        @Nullable
        private Object mTag;
        @Nullable
        private Boolean mOnMainThread;

        private RequestsBuilder() {
        }

        @Nonnull
        public RequestsBuilder withTag(@Nullable Object tag) {
            Check.isNull(this.mTag);
            this.mTag = tag;
            return this;
        }

        @Nonnull
        public RequestsBuilder onBackgroundThread() {
            Check.isNull(this.mOnMainThread);
            this.mOnMainThread = false;
            return this;
        }

        @Nonnull
        public RequestsBuilder onMainThread() {
            Check.isNull(this.mOnMainThread);
            this.mOnMainThread = true;
            return this;
        }

        @Nonnull
        public BillingRequests create() {
            return new Requests(this.mTag, this.mOnMainThread == null ? true : this.mOnMainThread);
        }
    }

    private final class OnConnectedServiceRunnable
    implements RequestRunnable {
        @Nullable
        @GuardedBy(value="this")
        private Request mRequest;

        public OnConnectedServiceRunnable(Request request) {
            this.mRequest = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run() {
            InAppBillingService localService;
            State localState;
            Request localRequest = this.getRequest();
            if (localRequest == null) {
                return true;
            }
            if (this.checkCache(localRequest)) {
                return true;
            }
            Object object = Billing.this.mLock;
            synchronized (object) {
                localState = Billing.this.mState;
                localService = Billing.this.mService;
            }
            if (localState == State.CONNECTED) {
                Check.isNotNull(localService);
                try {
                    localRequest.start(localService, Billing.this.mContext.getPackageName());
                }
                catch (RemoteException | RuntimeException | RequestException e) {
                    localRequest.onError((Exception)e);
                }
            } else {
                if (localState != State.FAILED) {
                    Billing.this.connect();
                    return false;
                }
                localRequest.onError(10000);
            }
            return true;
        }

        private boolean checkCache(@Nonnull Request request) {
            if (!Billing.this.mCache.hasCache()) {
                return false;
            }
            String key = request.getCacheKey();
            if (key == null) {
                return false;
            }
            Cache.Entry entry = Billing.this.mCache.get(request.getType().getCacheKey(key));
            if (entry == null) {
                return false;
            }
            request.onSuccess(entry.data);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Request getRequest() {
            OnConnectedServiceRunnable onConnectedServiceRunnable = this;
            synchronized (onConnectedServiceRunnable) {
                return this.mRequest;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            OnConnectedServiceRunnable onConnectedServiceRunnable = this;
            synchronized (onConnectedServiceRunnable) {
                if (this.mRequest != null) {
                    Billing.debug("Cancelling request: " + this.mRequest);
                    this.mRequest.cancel();
                }
                this.mRequest = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getId() {
            OnConnectedServiceRunnable onConnectedServiceRunnable = this;
            synchronized (onConnectedServiceRunnable) {
                return this.mRequest != null ? this.mRequest.getId() : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object getTag() {
            OnConnectedServiceRunnable onConnectedServiceRunnable = this;
            synchronized (onConnectedServiceRunnable) {
                return this.mRequest != null ? this.mRequest.getTag() : null;
            }
        }

        public String toString() {
            return String.valueOf(this.mRequest);
        }
    }

    private static final class StaticConfiguration
    implements Configuration {
        @Nonnull
        private final Configuration mOriginal;
        @Nonnull
        private final String mPublicKey;
        @Nonnull
        private PurchaseVerifier mPurchaseVerifier;

        private StaticConfiguration(@Nonnull Configuration original) {
            this.mOriginal = original;
            this.mPublicKey = original.getPublicKey();
            this.mPurchaseVerifier = original.getPurchaseVerifier();
        }

        @Override
        @Nonnull
        public String getPublicKey() {
            return this.mPublicKey;
        }

        @Override
        @Nullable
        public Cache getCache() {
            return this.mOriginal.getCache();
        }

        @Override
        @Nonnull
        public PurchaseVerifier getPurchaseVerifier() {
            return this.mPurchaseVerifier;
        }

        void setPurchaseVerifier(@Nonnull PurchaseVerifier purchaseVerifier) {
            this.mPurchaseVerifier = purchaseVerifier;
        }

        @Override
        @Nullable
        public Inventory getFallbackInventory(@Nonnull Checkout checkout, @Nonnull Executor onLoadExecutor) {
            return this.mOriginal.getFallbackInventory(checkout, onLoadExecutor);
        }

        @Override
        public boolean isAutoConnect() {
            return this.mOriginal.isAutoConnect();
        }
    }

    public static abstract class DefaultConfiguration
    implements Configuration {
        @Override
        @Nullable
        public Cache getCache() {
            return Billing.newCache();
        }

        @Override
        @Nonnull
        public PurchaseVerifier getPurchaseVerifier() {
            Billing.warning("Default purchase verification procedure is used, please read https://github.com/serso/android-checkout#purchase-verification");
            return Billing.newPurchaseVerifier(this.getPublicKey());
        }

        @Override
        @Nullable
        public Inventory getFallbackInventory(@Nonnull Checkout checkout, @Nonnull Executor onLoadExecutor) {
            return null;
        }

        @Override
        public boolean isAutoConnect() {
            return true;
        }
    }

    public static interface Configuration {
        @Nonnull
        public String getPublicKey();

        @Nullable
        public Cache getCache();

        @Nonnull
        public PurchaseVerifier getPurchaseVerifier();

        @Nullable
        public Inventory getFallbackInventory(@Nonnull Checkout var1, @Nonnull Executor var2);

        public boolean isAutoConnect();
    }

    static interface ServiceConnector {
        public boolean connect();

        public void disconnect();
    }

    static enum State {
        INITIAL,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED,
        FAILED;

    }
}

