/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.error;

import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.config.ExceptionHelper;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.soitoolkit.commons.mule.api.log.EventLogMessage;
import org.soitoolkit.commons.mule.api.log.EventLogger;
import org.soitoolkit.commons.mule.log.EventLoggerFactory;

public class ServiceExceptionStrategy
extends DefaultMessagingExceptionStrategy {
    private final EventLogger eventLogger;

    public ServiceExceptionStrategy(MuleContext muleContext) {
        super(muleContext);
        this.eventLogger = EventLoggerFactory.getEventLogger(muleContext);
    }

    protected void logException(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)t);
        if (muleException != null) {
            if (muleException instanceof MessagingException) {
                MessagingException me = (MessagingException)muleException;
                EventLogMessage elm = new EventLogMessage();
                elm.setMuleMessage(me.getMuleMessage());
                Object ex = me.getCause() == null ? me : me.getCause();
                this.eventLogger.logErrorEvent((Throwable)ex, elm);
            } else {
                Map info = ExceptionHelper.getExceptionInfo((Throwable)muleException);
                EventLogMessage elm = new EventLogMessage();
                this.eventLogger.logErrorEvent((Throwable)muleException, info.get("Payload"), elm);
            }
        } else {
            EventLogMessage elm = new EventLogMessage();
            this.eventLogger.logErrorEvent(t, null, elm);
        }
    }
}

