/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ComponentMessageNotificationListener;
import org.mule.api.context.notification.EndpointMessageNotificationListener;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.ExceptionNotification;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.soitoolkit.commons.mule.test.Dispatcher;
import org.soitoolkit.commons.mule.test.DispatcherMuleClientImpl;
import org.soitoolkit.commons.mule.util.MuleUtil;
import org.soitoolkit.commons.mule.util.ValueHolder;

public abstract class AbstractTestCase
extends FunctionalTestCase {
    protected String junitTestCaseName;

    public AbstractTestCase() {
        System.getProperties().put("spring.profiles.active", "soitoolkit-integrationtests");
        System.setProperty("org.apache.cxf.Logger", "org.apache.cxf.common.logging.Log4jLogger");
    }

    public String getName() {
        return this.junitTestCaseName;
    }

    public void setName(String name) {
        this.junitTestCaseName = name;
        super.setName(this.junitTestCaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleMessage dispatchAndWaitForDelivery(String inboundEndpointAddress, Object payload, Map<String, String> headers, final String outboundEndpointName, final int action, long timeout) {
        final ValueHolder receivedMessageHolder = new ValueHolder();
        final CountDownLatch latch = new CountDownLatch(1);
        EndpointMessageNotificationListener listener = null;
        MuleClient muleClient = null;
        try {
            muleClient = new MuleClient(muleContext);
            listener = new EndpointMessageNotificationListener(){

                public void onNotification(ServerNotification notification) {
                    if (AbstractTestCase.this.logger.isDebugEnabled()) {
                        AbstractTestCase.this.logger.debug((Object)("notification received on " + notification.getResourceIdentifier() + " (action: " + notification.getActionName() + ")"));
                    }
                    if (notification instanceof EndpointMessageNotification) {
                        EndpointMessageNotification endpointNotification = (EndpointMessageNotification)notification;
                        int actualAction = endpointNotification.getAction();
                        String actualEndpoint = MuleUtil.getEndpointName(endpointNotification);
                        if (AbstractTestCase.this.logger.isDebugEnabled()) {
                            AbstractTestCase.this.logger.debug((Object)(actualAction == action ? 1 : 0));
                            AbstractTestCase.this.logger.debug((Object)actualEndpoint.equals(outboundEndpointName));
                        }
                        if (actualAction == action && actualEndpoint.equals(outboundEndpointName)) {
                            if (AbstractTestCase.this.logger.isDebugEnabled()) {
                                AbstractTestCase.this.logger.debug((Object)("Expected notification received on " + actualEndpoint + " (action: " + endpointNotification.getActionName() + "), time to countdown the latch"));
                            }
                            receivedMessageHolder.value = endpointNotification.getSource();
                            latch.countDown();
                        } else if (AbstractTestCase.this.logger.isDebugEnabled()) {
                            AbstractTestCase.this.logger.debug((Object)("A not matching notification received on " + actualEndpoint + " (action: " + endpointNotification.getActionName() + "), continue to wait for the right one..."));
                        }
                    }
                }
            };
            muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
            muleClient.dispatch(inboundEndpointAddress, payload, headers);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Waiting for message to be delivered to the endpoint...");
            }
            boolean workDone = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(workDone ? "Message delivered, continue..." : "No message delivered, timeout occurred!"));
            }
            AbstractTestCase.assertTrue((String)("Test timed out. It took more than " + timeout + " milliseconds. If this error occurs the test probably needs a longer time out (on your computer/network)"), (boolean)workDone);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                AbstractTestCase.fail((String)("An unexpected error occurred: " + e.getMessage()));
            }
            catch (Throwable throwable) {
                muleClient.dispose();
                if (listener != null) {
                    muleContext.getNotificationManager().removeListener(listener);
                }
                throw throwable;
            }
            muleClient.dispose();
            if (listener != null) {
                muleContext.getNotificationManager().removeListener((ServerNotificationListener)listener);
            }
        }
        muleClient.dispose();
        if (listener != null) {
            muleContext.getNotificationManager().removeListener((ServerNotificationListener)listener);
        }
        return (MuleMessage)receivedMessageHolder.value;
    }

    protected MuleMessage waitForServiceComponent(String serviceComponentName, long timeout) {
        return this.dispatchAndWaitForServiceComponent(null, serviceComponentName, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleMessage dispatchAndWaitForServiceComponent(Dispatcher dispatcher, final String serviceComponentName, long timeout) {
        final ValueHolder receivedMessageHolder = new ValueHolder();
        final CountDownLatch latch = new CountDownLatch(1);
        ComponentMessageNotificationListener listener = null;
        try {
            listener = new ComponentMessageNotificationListener(){

                public void onNotification(ServerNotification notification) {
                    if (AbstractTestCase.this.logger.isDebugEnabled()) {
                        AbstractTestCase.this.logger.debug((Object)("notification received on " + notification.getResourceIdentifier() + " (action: " + notification.getActionName()));
                    }
                    if (notification instanceof ComponentMessageNotification) {
                        ComponentMessageNotification componentNotification = (ComponentMessageNotification)notification;
                        int action = componentNotification.getAction();
                        String component = componentNotification.getResourceIdentifier();
                        if (action == 1402 && component.equals(serviceComponentName)) {
                            if (AbstractTestCase.this.logger.isDebugEnabled()) {
                                AbstractTestCase.this.logger.debug((Object)("Expected notification received on " + serviceComponentName + " (action: " + componentNotification.getActionName() + "), time to countdown the latch"));
                            }
                            receivedMessageHolder.value = componentNotification.getSource();
                            latch.countDown();
                        }
                    }
                }
            };
            muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
            if (dispatcher != null) {
                dispatcher.doDispatch();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Waiting for message to be delivered to the endpoint...");
            }
            boolean workDone = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(workDone ? "Message delivered, continue..." : "No message delivered, timeout occurred!"));
            }
            AbstractTestCase.assertTrue((String)("Test timed out. It took more than " + timeout + " milliseconds. If this error occurs the test probably needs a longer time out (on your computer/network)"), (boolean)workDone);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractTestCase.fail((String)("An unexpected error occurred: " + e.getMessage()));
        }
        finally {
            if (listener != null) {
                muleContext.getNotificationManager().removeListener((ServerNotificationListener)listener);
            }
        }
        return (MuleMessage)receivedMessageHolder.value;
    }

    protected MuleMessage dispatchAndWaitForServiceComponent(String inboundEndpointAddress, Object payload, Map<String, String> headers, String serviceComponentName, long timeout) {
        return this.dispatchAndWaitForServiceComponent(new DispatcherMuleClientImpl(muleContext, inboundEndpointAddress, payload, headers), serviceComponentName, timeout);
    }

    protected Exception waitForException(long timeout) {
        return this.dispatchAndWaitForException(null, null, null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exception dispatchAndWaitForException(String inboundEndpointAddress, Object payload, Map<String, String> headers, long timeout) {
        final ValueHolder exceptionHolder = new ValueHolder();
        final CountDownLatch latch = new CountDownLatch(1);
        ExceptionNotificationListener listener = null;
        MuleClient muleClient = null;
        try {
            muleClient = new MuleClient(muleContext);
            listener = new ExceptionNotificationListener(){

                public void onNotification(ServerNotification notification) {
                    if (notification instanceof ExceptionNotification) {
                        ExceptionNotification exceptionNotification = (ExceptionNotification)notification;
                        Throwable exception = (Throwable)exceptionNotification.getSource();
                        int action = exceptionNotification.getAction();
                        if (action == 1101) {
                            if (AbstractTestCase.this.logger.isDebugEnabled()) {
                                AbstractTestCase.this.logger.debug((Object)("Expected exception occurred: " + exception.getMessage() + ", time to countdown the latch"));
                            }
                            exceptionHolder.value = exception;
                            latch.countDown();
                        } else if (AbstractTestCase.this.logger.isDebugEnabled()) {
                            AbstractTestCase.this.logger.debug((Object)("Unexpected exception-action: " + exceptionNotification.getActionName() + " , continue to wait for the exception..."));
                        }
                    }
                }
            };
            muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
            if (inboundEndpointAddress != null) {
                muleClient.dispatch(inboundEndpointAddress, payload, headers);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Waiting for an exception to occur...");
            }
            boolean workDone = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(workDone ? "Exception occurred, continue..." : "No exception occurred, instead a timeout occurred!"));
            }
            AbstractTestCase.assertTrue((String)("Test timed out. It took more than " + timeout + " milliseconds. If this error occurs the test probably needs a longer time out (on your computer/network)"), (boolean)workDone);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                AbstractTestCase.fail((String)("An unexpected error occurred: " + e.getMessage()));
            }
            catch (Throwable throwable) {
                muleClient.dispose();
                if (listener != null) {
                    muleContext.getNotificationManager().removeListener(listener);
                }
                throw throwable;
            }
            muleClient.dispose();
            if (listener != null) {
                muleContext.getNotificationManager().removeListener((ServerNotificationListener)listener);
            }
        }
        muleClient.dispose();
        if (listener != null) {
            muleContext.getNotificationManager().removeListener((ServerNotificationListener)listener);
        }
        return (Exception)exceptionHolder.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exception dispatchAndWaitForException(String inboundEndpointAddress, Object payload, Map<String, String> headers, String serviceName, long timeout) {
        ValueHolder exceptionHolder = new ValueHolder();
        CountDownLatch latch = new CountDownLatch(1);
        ExceptionNotificationListener listener = null;
        MuleClient muleClient = null;
        try {
            muleClient = new MuleClient(muleContext);
            listener = new ExceptionNotificationListener(){

                public void onNotification(ServerNotification notification) {
                    if (AbstractTestCase.this.logger.isDebugEnabled()) {
                        AbstractTestCase.this.logger.debug((Object)("notification received on " + notification.getResourceIdentifier() + " (action: " + notification.getActionName() + ")"));
                    }
                    System.err.println("### AbstractTestCase.dispatchAndWaitForException(...) received an notification of type: " + notification.getClass().getName());
                    if (notification instanceof ExceptionNotification) {
                        ExceptionNotification exceptionNotification = (ExceptionNotification)notification;
                    }
                }
            };
            muleContext.getNotificationManager().addListener((ServerNotificationListener)listener);
            muleClient.dispatch(inboundEndpointAddress, payload, headers);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Waiting for an exception to occur...");
            }
            boolean workDone = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(workDone ? "Exception occurred, continue..." : "No exception occurred, instead a timeout occurred!"));
            }
            AbstractTestCase.assertTrue((String)("Test timed out. It took more than " + timeout + " milliseconds. If this error occurs the test probably needs a longer time out (on your computer/network)"), (boolean)workDone);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractTestCase.fail((String)("An unexpected error occurred: " + e.getMessage()));
        }
        finally {
            muleClient.dispose();
            if (listener != null) {
                muleContext.getNotificationManager().removeListener((ServerNotificationListener)listener);
            }
        }
        return (Exception)exceptionHolder.value;
    }
}

