/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.service.Service;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.util.MiscUtil;
import org.soitoolkit.commons.mule.util.MuleUtil;

public class SftpUtil {
    private static final Logger logger = LoggerFactory.getLogger(SftpUtil.class);

    private SftpUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static void initEndpointDirectories(MuleContext muleContext, String[] serviceNames, String[] endpointNames) throws Exception {
        ArrayList<Lifecycle> services = new ArrayList<Lifecycle>();
        for (String serviceName : serviceNames) {
            try {
                Lifecycle service = (Lifecycle)muleContext.getRegistry().lookupObject(serviceName);
                services.add(service);
            }
            catch (Exception e) {
                logger.error("Error '" + e.getMessage() + "' occured while stopping the service " + serviceName + ". Perhaps the service did not exist in the config?");
                throw e;
            }
        }
        for (String endpointName : endpointNames) {
            SftpUtil.initEndpointDirectory(muleContext, endpointName);
        }
        for (Lifecycle service : services) {
        }
    }

    private static void logServiceStatus(Service service) {
        System.err.println(service.getName() + " started: " + service.isStarted() + ", stopped: " + service.isStopped() + ", paused: " + service.isPaused());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initEndpointDirectory(MuleContext muleContext, String endpointName) throws MuleException, IOException, SftpException {
        SftpClient sftpClient = SftpUtil.getSftpClient(muleContext, endpointName);
        try {
            ChannelSftp channelSftp;
            block6: {
                channelSftp = sftpClient.getChannelSftp();
                try {
                    SftpUtil.recursiveDelete(muleContext, sftpClient, endpointName, "");
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error("Failed to recursivly delete endpoint " + endpointName, (Throwable)e);
                }
            }
            String path = SftpUtil.getPathByEndpoint(muleContext, sftpClient, endpointName);
            SftpUtil.mkDirs(channelSftp, path);
        }
        finally {
            sftpClient.disconnect();
            if (logger.isDebugEnabled()) {
                logger.debug("Done init endpoint directory: " + endpointName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getFilesInEndpoint(MuleContext muleContext, String endpointName, String subDirectory) throws IOException, MuleException {
        SftpClient sftpClient = SftpUtil.getSftpClient(muleContext, endpointName);
        ImmutableEndpoint tEndpoint = MuleUtil.getImmutableEndpoint(muleContext, endpointName);
        try {
            String[] files;
            String path = tEndpoint.getEndpointURI().getPath();
            if (subDirectory != null) {
                path = path + '/' + subDirectory;
            }
            String[] stringArray = files = SftpUtil.getFilesInPath(sftpClient, path);
            return stringArray;
        }
        finally {
            sftpClient.disconnect();
        }
    }

    public static String[] getFilesInPath(SftpClient sftpClient, String path) throws IOException {
        sftpClient.changeWorkingDirectory(sftpClient.getAbsolutePath(path));
        String[] files = sftpClient.listFiles();
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSftpFileContent(MuleContext muleContext, String endpointName, String file) throws MuleException, IOException {
        SftpClient sftpClient = SftpUtil.getSftpClient(muleContext, endpointName);
        ImmutableEndpoint tEndpoint = MuleUtil.getImmutableEndpoint(muleContext, endpointName);
        try {
            String path = tEndpoint.getEndpointURI().getPath();
            sftpClient.changeWorkingDirectory(sftpClient.getAbsolutePath(path));
            InputStream is = sftpClient.retrieveFile(file);
            String string = MiscUtil.convertStreamToString(is);
            return string;
        }
        finally {
            sftpClient.disconnect();
        }
    }

    private static void mkDirs(ChannelSftp channelSftp, String path) {
        int lastSepPos = path.lastIndexOf(47);
        if (lastSepPos > 0) {
            String parentPath = path.substring(0, lastSepPos);
            SftpUtil.mkDirs(channelSftp, parentPath);
        }
        try {
            channelSftp.mkdir(path);
        }
        catch (SftpException sftpException) {
            // empty catch block
        }
    }

    protected static SftpClient getSftpClient(MuleContext muleContext, String endpointName) throws IOException {
        ImmutableEndpoint endpoint = MuleUtil.getImmutableEndpoint(muleContext, endpointName);
        try {
            SftpClient sftpClient = SftpConnectionFactory.createClient((ImmutableEndpoint)endpoint);
            return sftpClient;
        }
        catch (Exception e) {
            throw new RuntimeException("Login failed", e);
        }
    }

    protected static String getPathByEndpoint(MuleContext muleContext, SftpClient sftpClient, String endpointName) throws IOException {
        ImmutableEndpoint endpoint = MuleUtil.getImmutableEndpoint(muleContext, endpointName);
        EndpointURI endpointURI = endpoint.getEndpointURI();
        return sftpClient.getAbsolutePath(endpointURI.getPath());
    }

    protected static void recursiveDelete(MuleContext muleContext, SftpClient sftpClient, String endpointName, String relativePath) throws IOException {
        block7: {
            EndpointURI endpointURI = MuleUtil.getImmutableEndpoint(muleContext, endpointName).getEndpointURI();
            String path = endpointURI.getPath() + relativePath;
            try {
                String[] files;
                String[] directories;
                sftpClient.chmod(path, 448);
                sftpClient.changeWorkingDirectory(sftpClient.getAbsolutePath(path));
                for (String directory : directories = sftpClient.listDirectories()) {
                    SftpUtil.recursiveDelete(muleContext, sftpClient, endpointName, relativePath + "/" + directory);
                }
                sftpClient.changeWorkingDirectory(sftpClient.getAbsolutePath(path));
                for (String file : files = sftpClient.listFiles()) {
                    sftpClient.deleteFile(file);
                }
                try {
                    sftpClient.deleteDirectory(path);
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed delete directory " + path, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug("Failed to recursivly delete directory " + path, (Throwable)e);
            }
        }
    }
}

