/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.mail;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.mail.MailMessage;
import org.soitoolkit.commons.mule.mail.UsrPwdAuthenticator;

public class MailUtil {
    private static final Logger logger = LoggerFactory.getLogger(MailUtil.class);

    private MailUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static List<MailMessage> receiveMessagesUsingImap(String host, String username, String password, boolean deleteReadMessages, boolean debug) {
        return MailUtil.receiveMessages("imap", host, username, password, deleteReadMessages, debug);
    }

    public static List<MailMessage> receiveMessages(String protocol, String host, String username, String password, boolean deleteReadMessages, boolean debug) {
        try {
            Properties props = new Properties();
            props.put("mail.debug", debug ? "true" : "false");
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new UsrPwdAuthenticator(username, password));
            session.setDebug(debug);
            Store store = session.getStore(protocol);
            store.connect(host, username, password);
            Folder folder = store.getFolder("INBOX");
            folder.open(deleteReadMessages ? 2 : 1);
            Message[] messages = folder.getMessages();
            ArrayList<MailMessage> msgs = new ArrayList<MailMessage>();
            int n = messages.length;
            for (int i = 0; i < n; ++i) {
                msgs.add(new MailMessage(messages[i]));
                if (!deleteReadMessages) continue;
                messages[i].setFlag(Flags.Flag.DELETED, true);
            }
            folder.close(deleteReadMessages);
            store.close();
            return msgs;
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendSmtpSslMessage(String smtpHost, String smtpSslPort, String username, String password, String from, String to, String subject, String content, List<String> filenames, boolean debug) {
        logger.info("Send mail to {}, content: {}.", (Object)to, (Object)content);
        Security.addProvider((java.security.Provider)new Provider());
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", smtpHost);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", smtpSslPort);
        props.put("mail.smtp.socketFactory.port", smtpSslPort);
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.socketFactory.fallback", "false");
        props.put("mail.debug", debug ? "true" : "false");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new UsrPwdAuthenticator(username, password));
        session.setDebug(debug);
        MailUtil.sendMimeMessage(from, to, subject, content, filenames, session);
        logger.info("Mail sent");
    }

    public static void sendSmtpMessageNoAuth(String smtpHost, String smtpPort, String from, String to, String subject, String content, List<String> filenames, boolean debug) {
        logger.info("Send mail to {}, content: {}.", (Object)to, (Object)content);
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", smtpHost);
        props.put("mail.smtp.auth", "false");
        props.put("mail.smtp.port", smtpPort);
        props.put("mail.debug", debug ? "true" : "false");
        Session session = Session.getDefaultInstance((Properties)props);
        session.setDebug(debug);
        MailUtil.sendMimeMessage(from, to, subject, content, filenames, session);
        logger.info("Mail sent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMimeMessage(String from, String to, String subject, String content, List<String> filenames, Session session) {
        try {
            DataSource[] attachments;
            String[] toArr = new String[]{to};
            DataSource[] dataSourceArray = attachments = filenames == null ? null : new DataSource[filenames.size()];
            if (filenames != null) {
                int i = 0;
                for (String filename : filenames) {
                    attachments[i++] = new FileDataSource(filename);
                }
            }
            MimeMessage message = MailUtil.createMimeMessage(session, from, toArr, subject, content, attachments);
            message.saveChanges();
            Transport transport = session.getTransport();
            try {
                transport.connect();
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            finally {
                transport.close();
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getText(Part part) {
        try {
            ContentType contentType = new ContentType(part.getContentType());
            System.err.println("contentType: " + part.getContentType() + ", class: " + part.getContent().getClass().getName());
            if (part.isMimeType("text/*")) {
                String charset = contentType.getParameter("charset");
                System.err.println("Charset: " + charset);
                return (String)part.getContent();
            }
            if (part.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)part.getContent();
                for (int i = 0; i < mp.getCount(); ++i) {
                    String text = MailUtil.getText((Part)mp.getBodyPart(i));
                    if (text == null) continue;
                    return text;
                }
            }
            return null;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fillAddresses(Message mail, Message.RecipientType addrType, List<String> addrList) {
        try {
            Address[] receipients = mail.getRecipients(addrType);
            if (receipients == null) {
                return;
            }
            for (Address address : receipients) {
                addrList.add(address.toString());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MimeMessage createMimeMessage(Session session, String from, String[] to, String subject, String content, DataSource[] attachments) {
        logger.debug("Creates a mime message with {} attachments", (Object)(attachments == null ? 0 : attachments.length));
        try {
            MimeMessage message = new MimeMessage(session);
            if (from != null) {
                message.setSender((Address)new InternetAddress(from));
            }
            if (subject != null) {
                message.setSubject(subject, "UTF-8");
            }
            if (to != null) {
                for (String toAdr : to) {
                    message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAdr));
                }
            }
            if (attachments == null || attachments.length == 0) {
                message.setContent((Object)content, "text/plain; charset=UTF-8");
            } else {
                MimeMultipart multipart = new MimeMultipart();
                message.setContent((Multipart)multipart);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)content, "text/plain; charset=UTF-8");
                multipart.addBodyPart((BodyPart)messageBodyPart);
                if (attachments != null) {
                    for (DataSource attachment : attachments) {
                        MimeBodyPart attatchmentBodyPart = new MimeBodyPart();
                        attatchmentBodyPart.setDataHandler(new DataHandler(attachment));
                        attatchmentBodyPart.setFileName(attachment.getName());
                        multipart.addBodyPart((BodyPart)attatchmentBodyPart);
                    }
                }
            }
            return message;
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(String filename, byte[] content) throws IOException {
        MailUtil.saveFile(filename, new ByteArrayInputStream(content));
    }

    public static void saveFile(String filename, InputStream inputStream) throws IOException {
        File file = MailUtil.createFileWithUniqueName(filename);
        MailUtil.copy(inputStream, file);
        System.err.println("### Wrote attachement to file: " + file.getAbsolutePath());
    }

    public static File createFileWithUniqueName(String orgFilename) throws IOException {
        File file = new File(orgFilename);
        if (!file.exists()) {
            return file;
        }
        int fileTypeIdx = orgFilename.lastIndexOf(46);
        String filename = orgFilename;
        String fileType = "";
        if (fileTypeIdx >= 0) {
            fileType = filename.substring(fileTypeIdx);
            filename = filename.substring(0, fileTypeIdx);
        }
        int i = 0;
        while (file.exists()) {
            file = new File(filename + '-' + i + fileType);
            ++i;
        }
        return file;
    }

    public static byte[] copy(InputStream src) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MailUtil.copy(src, baos);
        return baos.toByteArray();
    }

    public static void copy(InputStream src, File dst) throws IOException {
        MailUtil.copy(src, new FileOutputStream(dst));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dst) throws IOException {
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = src.read(buf)) > 0) {
                dst.write(buf, 0, len);
            }
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (dst != null) {
                dst.flush();
                dst.close();
            }
        }
    }
}

